/*
 * Decompiled with CFR 0.152.
 */
package com.anji.fingerprint;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Classification {
    private String name;
    private static Map classificationMap;
    private static List classificationList;
    private int confusionMatrixIndex;
    public static final Classification WHORL;
    public static final Classification RIGHT_LOOP;
    public static final Classification LEFT_LOOP;
    public static final Classification ARCH;
    public static final Classification TENTED_ARCH;
    public static final Classification NONE;

    static {
        WHORL = new Classification("W", 0);
        RIGHT_LOOP = new Classification("R", 1);
        LEFT_LOOP = new Classification("L", 2);
        ARCH = new Classification("A", 3);
        TENTED_ARCH = new Classification("T", 4);
        NONE = new Classification("X", 5);
    }

    private Classification(String aName, int aConfusionIndex) {
        this.name = aName;
        this.confusionMatrixIndex = aConfusionIndex;
    }

    public static Classification valueOf(String name) {
        if (classificationMap == null) {
            classificationMap = new HashMap();
            classificationMap.put(WHORL.toString(), WHORL);
            classificationMap.put(RIGHT_LOOP.toString(), RIGHT_LOOP);
            classificationMap.put(LEFT_LOOP.toString(), LEFT_LOOP);
            classificationMap.put(ARCH.toString(), ARCH);
            classificationMap.put(TENTED_ARCH.toString(), TENTED_ARCH);
            classificationMap.put(NONE.toString(), NONE);
        }
        Classification result2 = (Classification)classificationMap.get(name.toUpperCase());
        return result2;
    }

    public static List getClassifications() {
        if (classificationList == null) {
            classificationList = new ArrayList();
            classificationList.add(WHORL);
            classificationList.add(RIGHT_LOOP);
            classificationList.add(LEFT_LOOP);
            classificationList.add(ARCH);
            classificationList.add(TENTED_ARCH);
            classificationList.add(NONE);
        }
        return classificationList;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public int getConfusionMatrixIndex() {
        return this.confusionMatrixIndex;
    }
}

