/*
 * Decompiled with CFR 0.152.
 */
package com.anji.fingerprint;

import com.anji.fingerprint.Classification;
import com.anji.fingerprint.ClassifierResult;
import com.anji.imaging.Identifier;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class Classifier {
    private static Logger logger = Logger.getLogger(Classifier.class);
    private Map identifiers = new HashMap();

    public void addIdentifier(Classification classification, Identifier identifier) {
        ArrayList<Identifier> classIdentifiers = (ArrayList<Identifier>)this.identifiers.get(classification);
        if (classIdentifiers == null) {
            classIdentifiers = new ArrayList<Identifier>();
            this.identifiers.put(classification, classIdentifiers);
        }
        classIdentifiers.add(identifier);
    }

    public ClassifierResult classify(File imgFile) throws IOException {
        long startTime = System.currentTimeMillis();
        ClassifierResult result2 = new ClassifierResult();
        Iterator classificationIterator = this.identifiers.keySet().iterator();
        while (classificationIterator.hasNext()) {
            float total = 0.0f;
            Classification classification = (Classification)classificationIterator.next();
            Collection classIdentifiers = (Collection)this.identifiers.get(classification);
            if (classIdentifiers == null) continue;
            for (Identifier identifier : classIdentifiers) {
                total += identifier.identify(imgFile);
            }
            result2.setConfidence(classification, total / (float)classIdentifiers.size());
        }
        logger.info("classification took " + (System.currentTimeMillis() - startTime) + " ms");
        return result2;
    }
}

