/*
 * Decompiled with CFR 0.152.
 */
package com.anji.fingerprint;

import com.anji.fingerprint.Classification;
import java.util.HashMap;
import java.util.Map;

public class ClassifierResult {
    public static final float DEFAULT_CONFIDENCE = 0.5f;
    private Map confidences = new HashMap();
    private Classification primaryClassification = Classification.NONE;
    private Classification secondaryClassification = Classification.NONE;
    private float primaryConfidence = 0.5f;
    private float secondaryConfidence = 0.5f;

    public void setConfidence(Classification aClassification, float confidence) {
        if (this.confidences.get(aClassification) != null) {
            throw new IllegalArgumentException("confidence already set for " + aClassification);
        }
        this.confidences.put(aClassification, new Float(confidence));
        if (confidence > this.primaryConfidence) {
            this.secondaryConfidence = this.primaryConfidence;
            this.secondaryClassification = this.primaryClassification;
            this.primaryConfidence = confidence;
            this.primaryClassification = aClassification;
        } else if (confidence > this.secondaryConfidence) {
            this.secondaryConfidence = confidence;
            this.secondaryClassification = aClassification;
        }
    }

    public Classification getPrimaryClassification() {
        return this.primaryClassification;
    }

    public Classification getSecondaryClassification() {
        return this.secondaryClassification;
    }

    public float getConfidence(Classification aClassification) {
        Float confidence = (Float)this.confidences.get(aClassification);
        return confidence == null ? 0.5f : confidence.floatValue();
    }

    public String toString() {
        return this.confidences.toString();
    }
}

