/*
 * Decompiled with CFR 0.152.
 */
package com.anji.fingerprint;

import com.anji.fingerprint.Classification;

public class ConfusionMatrix {
    private int[][] values = new int[Classification.getClassifications().size()][Classification.getClassifications().size()];

    public void setCount(Classification actual, Classification machine, int count) {
        this.values[actual.getConfusionMatrixIndex()][machine.getConfusionMatrixIndex()] = count;
    }

    public int getCount(Classification actual, Classification machine) {
        return this.values[actual.getConfusionMatrixIndex()][machine.getConfusionMatrixIndex()];
    }

    public void increment(Classification actual, Classification machine) {
        int[] nArray = this.values[actual.getConfusionMatrixIndex()];
        int n = machine.getConfusionMatrixIndex();
        nArray[n] = nArray[n] + 1;
    }

    public int[][] getValues() {
        return this.values;
    }

    public String toString() {
        return this.toString("\t");
    }

    public String toString(String sep) {
        StringBuffer result2 = new StringBuffer();
        for (Classification cl : Classification.getClassifications()) {
            result2.append(sep).append(cl.toString());
        }
        result2.append(sep).append("Rjct %");
        result2.append(sep).append("TP %");
        result2.append("\n");
        int totalCorrect = 0;
        int totalRejected = 0;
        int totalIncorrect = 0;
        for (Classification cl : Classification.getClassifications()) {
            result2.append(cl.toString());
            int idx = cl.getConfusionMatrixIndex();
            int rowCorrect = 0;
            int rowRejected = 0;
            int rowIncorrect = 0;
            int[] row = this.values[idx];
            int i = 0;
            while (i < row.length) {
                result2.append(sep).append(row[i]);
                if (i == Classification.NONE.getConfusionMatrixIndex()) {
                    rowRejected += row[i];
                } else if (i == idx) {
                    rowCorrect += row[i];
                } else {
                    rowIncorrect += row[i];
                }
                ++i;
            }
            result2.append(sep).append((float)(rowRejected * 100) / (float)(rowRejected + rowCorrect + rowIncorrect));
            result2.append(sep).append((float)(rowCorrect * 100) / (float)(rowCorrect + rowIncorrect));
            result2.append("\n");
            totalCorrect += rowCorrect;
            totalRejected += rowRejected;
            totalIncorrect += rowIncorrect;
        }
        result2.append("Rjct %").append(sep).append((float)(totalRejected * 100) / (float)(totalRejected + totalCorrect + totalIncorrect)).append("\n");
        result2.append("Accur:").append(sep).append((float)(totalCorrect * 100) / (float)(totalCorrect + totalIncorrect));
        return result2.toString();
    }
}

