/*
 * Decompiled with CFR 0.152.
 */
package com.anji.fingerprint;

import com.anji.fingerprint.Classification;
import com.anji.fingerprint.Classifier;
import com.anji.fingerprint.ClassifierResult;
import com.anji.fingerprint.ConfusionMatrix;
import com.anji.floatingeye.AnjiNetFloatingEyeIdentifierFactory;
import com.anji.imaging.ImageFileFilter;
import com.anji.imaging.Surface;
import com.anji.integration.AnjiNetTranscriber;
import com.anji.nn.AnjiNet;
import com.anji.persistence.Persistence;
import com.anji.util.Configurable;
import com.anji.util.DummyConfiguration;
import com.anji.util.Properties;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.jgap.Chromosome;

public class Evaluator
implements Configurable {
    private static Logger logger = Logger.getLogger(Evaluator.class);
    private static final String EVAL_CHROM_PREFIX = "fingerprint.eval.chromosomes.";
    private static final String EVAL_IMGS_KEY = "fingerprint.eval.images";
    private Classifier classifier = new Classifier();
    private File imgDir;
    private AnjiNetFloatingEyeIdentifierFactory identifierFactory;
    private AnjiNetTranscriber transcriber;

    @Override
    public void init(Properties props) throws Exception {
        this.transcriber = (AnjiNetTranscriber)props.singletonObjectProperty(AnjiNetTranscriber.class);
        this.identifierFactory = (AnjiNetFloatingEyeIdentifierFactory)props.singletonObjectProperty(AnjiNetFloatingEyeIdentifierFactory.class);
        Persistence db = (Persistence)props.singletonObjectProperty("persistence");
        this.imgDir = props.getDirProperty(EVAL_IMGS_KEY);
        File[] imgFiles = this.imgDir.listFiles(ImageFileFilter.getInstance());
        if (imgFiles.length < 1) {
            throw new IllegalArgumentException("no image files");
        }
        Surface surface = (Surface)props.newObjectProperty("eye.surface");
        surface.setImage(imgFiles[0]);
        for (String string : props.keySet()) {
            if (!string.startsWith(EVAL_CHROM_PREFIX)) continue;
            String classID = string.substring(EVAL_CHROM_PREFIX.length());
            Classification classification = Classification.valueOf(classID);
            if (classification == null) {
                throw new IllegalArgumentException("unknown classification: " + classID);
            }
            StringTokenizer tok = new StringTokenizer(props.getProperty(string), ",");
            while (tok.hasMoreTokens()) {
                String chromID = tok.nextToken();
                Chromosome c2 = db.loadChromosome(chromID, new DummyConfiguration());
                AnjiNet net = this.transcriber.newAnjiNet(c2);
                this.classifier.addIdentifier(classification, this.identifierFactory.getIdentifier(net, surface));
            }
        }
    }

    private TargetClassification parseClassification(File f) {
        String classID = f.getName().substring(9);
        if ((classID = classID.substring(0, classID.indexOf(46))) == null || classID.length() <= 0) {
            throw new IllegalArgumentException("could not parse classification from " + f.getAbsolutePath());
        }
        TargetClassification result2 = new TargetClassification();
        result2.primary = Classification.valueOf(classID.substring(0, 1));
        if (classID.length() > 1) {
            result2.secondary = Classification.valueOf(classID.substring(1, 1));
        }
        return result2;
    }

    public ConfusionMatrix evaluate() throws IOException {
        ConfusionMatrix result2 = new ConfusionMatrix();
        File[] imgFiles = this.imgDir.listFiles(ImageFileFilter.getInstance());
        int i = 0;
        while (i < imgFiles.length) {
            File f = imgFiles[i];
            TargetClassification target = null;
            try {
                target = this.parseClassification(f);
            }
            catch (Throwable th) {
                logger.warn("could not parse file " + f.getAbsolutePath());
            }
            ClassifierResult cr = this.classifier.classify(f);
            result2.increment(target.primary, cr.getPrimaryClassification());
            ++i;
        }
        return result2;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("ANJI v2.0, Copyright (C) 2004 Derek James and Philip Tucker\nANJI comes with ABSOLUTELY NO WARRANTY\nThis is free software, and you are welcome to redistribute it\nunder the conditions of the GNU General Public License.");
        if (args.length < 1) {
            System.err.println("usage: <cmd> <properties-file>");
        }
        Evaluator ev = new Evaluator();
        Properties props = new Properties(args[0]);
        ev.init(props);
        System.out.println(ev.evaluate().toString());
    }

    private class TargetClassification {
        Classification primary = Classification.NONE;
        Classification secondary = Classification.NONE;

        private TargetClassification() {
        }

        public String toString() {
            return String.valueOf(this.primary.toString()) + this.secondary.toString();
        }
    }
}

