/*
 * Decompiled with CFR 0.152.
 */
package com.anji.floatingeye;

import com.anji.floatingeye.AffinityListener;
import com.anji.floatingeye.EyeMovementParms;
import com.anji.floatingeye.EyePixelConnection;
import com.anji.floatingeye.FloatingEye;
import com.anji.floatingeye.LocationXConnection;
import com.anji.floatingeye.LocationYConnection;
import com.anji.floatingeye.LocationZConnection;
import com.anji.floatingeye.ThetaConnection;
import com.anji.imaging.DoubleLocation2D;
import com.anji.imaging.RangeTranslator;
import com.anji.imaging.RangeTranslatorFactory;
import com.anji.imaging.Surface;
import com.anji.nn.AnjiNet;
import com.anji.nn.BiasConnection;
import com.anji.nn.Connection;
import com.anji.nn.Neuron;
import com.anji.util.XmlPersistable;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class AnjiNetFloatingEye
implements XmlPersistable {
    private static Logger logger = Logger.getLogger(AnjiNetFloatingEye.class);
    private static final String XML_TAG = "AnjiNetFloatingEye";
    private AnjiNet net;
    private Neuron affinityOutputNeuron;
    private RangeTranslator affinityTranslator;
    private FloatingEye floatingEye;
    private AffinityListener affinityListener;

    public AnjiNetFloatingEye(AnjiNet aNet, Surface aSurface, int anEyeDim, EyeMovementParms movementParms, AffinityListener anAffinityListener, List additionalInputConnections) {
        if (anEyeDim < 1) {
            throw new IllegalArgumentException("eye dimensions must be >= 1");
        }
        int inputCount = 1 + additionalInputConnections.size() + anEyeDim * anEyeDim;
        int outputCount = 1;
        if (movementParms.getMaxXMovePerStep() > 0.0) {
            ++inputCount;
            ++outputCount;
        }
        if (movementParms.getMaxYMovePerStep() > 0.0) {
            ++inputCount;
            ++outputCount;
        }
        if (movementParms.getMaxZMovePerStep() > 0.0) {
            ++inputCount;
            ++outputCount;
        }
        if (movementParms.getMaxThetaMovePerStep() > 0.0) {
            ++inputCount;
            ++outputCount;
        }
        if (aNet.getInputDimension() < inputCount) {
            throw new IllegalArgumentException("network input dimensions must be >= " + inputCount);
        }
        if (aNet.getOutputDimension() < outputCount) {
            throw new IllegalArgumentException("network output dimensions must be >= " + outputCount);
        }
        this.floatingEye = new FloatingEye(aNet.getName(), aNet.getOutputNeurons(0, outputCount - 1), aSurface, anEyeDim, movementParms);
        this.net = aNet;
        this.affinityOutputNeuron = aNet.getOutputNeuron(outputCount - 1);
        this.affinityListener = anAffinityListener;
        this.affinityTranslator = RangeTranslatorFactory.getInstance().getTranslator(this.affinityOutputNeuron.getFunc().getMinValue(), this.affinityOutputNeuron.getFunc().getMaxValue(), 0.0, 1.0);
        this.connectToInputNeurons(additionalInputConnections, movementParms.getMaxXMovePerStep() > 0.0, movementParms.getMaxYMovePerStep() > 0.0, movementParms.getMaxZMovePerStep() > 0.0, movementParms.getMaxThetaMovePerStep() > 0.0);
        this.reset();
    }

    @Override
    public synchronized String toXml() {
        StringBuffer result2 = new StringBuffer();
        result2.append("<").append(XML_TAG).append(">");
        result2.append(this.net.toXml());
        result2.append(this.floatingEye.toXml());
        result2.append("</").append(XML_TAG).append(">");
        return result2.toString();
    }

    public String toString() {
        return String.valueOf(this.floatingEye.toString()) + ": affinity=" + DoubleLocation2D.TO_STRING_FORMAT.format(this.affinityTranslator.translate(this.affinityOutputNeuron.getValue()));
    }

    public synchronized void reset() {
        this.net.reset();
        this.floatingEye.reset();
        this.affinityListener.reset();
    }

    private synchronized void connectToInputNeurons(List additionalInputConnections, boolean includeX, boolean includeY, boolean includeZ, boolean includeTheta) {
        int inputIdx = 0;
        if (includeX) {
            Neuron xInputNeuron = this.net.getInputNeuron(inputIdx++);
            xInputNeuron.addIncomingConnection(new LocationXConnection(this.floatingEye));
        }
        if (includeY) {
            Neuron yInputNeuron = this.net.getInputNeuron(inputIdx++);
            yInputNeuron.addIncomingConnection(new LocationYConnection(this.floatingEye));
        }
        if (includeZ) {
            Neuron zInputNeuron = this.net.getInputNeuron(inputIdx++);
            zInputNeuron.addIncomingConnection(new LocationZConnection(this.floatingEye));
        }
        if (includeTheta) {
            Neuron thetaInputNeuron = this.net.getInputNeuron(inputIdx++);
            thetaInputNeuron.addIncomingConnection(new ThetaConnection(this.floatingEye));
        }
        Neuron biasNeuron = this.net.getInputNeuron(inputIdx++);
        biasNeuron.addIncomingConnection(BiasConnection.getInstance());
        Iterator it = additionalInputConnections.iterator();
        while (it.hasNext()) {
            Neuron n = this.net.getInputNeuron(inputIdx++);
            n.addIncomingConnection((Connection)it.next());
        }
        int x = 0;
        while (x < this.floatingEye.getWidth()) {
            int y = 0;
            while (y < this.floatingEye.getHeight()) {
                EyePixelConnection pixConn = new EyePixelConnection(x, y, this.floatingEye);
                Neuron pixNeuron = this.net.getInputNeuron(inputIdx++);
                pixNeuron.addIncomingConnection(pixConn);
                ++y;
            }
            ++x;
        }
        if (this.net.getInputDimension() != inputIdx) {
            logger.warn("AnjiNetFloatingEye did not use all inputs from " + this.net.toString());
        }
    }

    public void step(int count) {
        int i = 0;
        while (i < count) {
            this.step();
            ++i;
        }
    }

    public synchronized void step() {
        this.floatingEye.step();
        this.affinityListener.updateAffinity(this.floatingEye.getSurfaceLocation(), this.affinityTranslator.translate(this.affinityOutputNeuron.getValue()));
        this.net.step();
    }

    public synchronized int getStepNum() {
        return this.floatingEye.getStepNum();
    }

    public long cost() {
        return this.net.cost();
    }

    public FloatingEye getFloatingEye() {
        return this.floatingEye;
    }

    @Override
    public String getXmlRootTag() {
        return null;
    }

    @Override
    public String getXmld() {
        return null;
    }
}

