/*
 * Decompiled with CFR 0.152.
 */
package com.anji.floatingeye;

import com.anji.floatingeye.AnjiNetFloatingEyeImageIdentifier;
import com.anji.floatingeye.EyeMovementParms;
import com.anji.imaging.Java2DSurface;
import com.anji.imaging.Surface;
import com.anji.nn.AnjiNet;
import com.anji.util.Configurable;
import com.anji.util.Properties;

public class AnjiNetFloatingEyeIdentifierFactory
implements Configurable {
    public static final String EYE_MAX_X_KEY = "eye.max-per-step.x";
    public static final String EYE_MAX_Y_KEY = "eye.max-per-step.y";
    public static final String EYE_MAX_Z_KEY = "eye.max-per-step.z";
    public static final String EYE_MAX_THETA_KEY = "eye.max-per-step.theta";
    private static final String EYE_DIM_KEY = "eye.dimension";
    private static final String EVAL_FRINKS_KEY = "eye.eval.frinks";
    private static final String EVAL_STEPS_KEY = "eye.eval.steps";
    private static final String FLIP_ENABLED_KEY = "eye.flip.enabled";
    private static final String EYE_DISPLAY_KEY = "eye.display";
    private static final String EYE_STEP_SLEEP_MILLIS_KEY = "eye.step.sleep.millis";
    private static final String EYE_ZOOM_START_KEY = "eye.zoom.start";
    private int evalFactor;
    private int evalSteps;
    private boolean flipEnabled;
    private int eyeDim;
    private double maxXPerStep;
    private double maxYPerStep;
    private double maxZPerStep;
    private double maxThetaPerStep;
    private long stepSleepMillis;
    private double eyeStartZoom;
    private boolean doDisplay;

    @Override
    public void init(Properties props) {
        this.maxXPerStep = props.getDoubleProperty(EYE_MAX_X_KEY, 1.0);
        this.maxYPerStep = props.getDoubleProperty(EYE_MAX_Y_KEY, 1.0);
        this.maxZPerStep = props.getDoubleProperty(EYE_MAX_Z_KEY, 1.0);
        this.maxThetaPerStep = props.getDoubleProperty(EYE_MAX_THETA_KEY, 1.0);
        this.eyeDim = props.getIntProperty(EYE_DIM_KEY);
        this.evalSteps = props.getIntProperty(EVAL_STEPS_KEY, -1);
        int evalFrinks = props.getIntProperty(EVAL_FRINKS_KEY, -1);
        if (this.evalSteps <= 0 && evalFrinks <= 0) {
            throw new IllegalArgumentException("must specify positive value for either eye.eval.frinks or eye.eval.steps");
        }
        if (this.evalSteps > 0 && evalFrinks > 0) {
            throw new IllegalArgumentException("can not specify positive values for both eye.eval.frinks and eye.eval.steps");
        }
        this.evalFactor = evalFrinks > 0 ? evalFrinks * 1000000 : -1;
        this.flipEnabled = props.getBooleanProperty(FLIP_ENABLED_KEY, true);
        this.stepSleepMillis = props.getLongProperty(EYE_STEP_SLEEP_MILLIS_KEY, 0L);
        this.eyeStartZoom = props.getDoubleProperty(EYE_ZOOM_START_KEY, 1.0);
        this.doDisplay = props.getBooleanProperty(EYE_DISPLAY_KEY, false);
        Class surfaceClass = props.getClassProperty("eye.surface.class");
        if (this.doDisplay && !Java2DSurface.class.isAssignableFrom(surfaceClass)) {
            throw new IllegalArgumentException("eye display requires Java2DSurface");
        }
    }

    public AnjiNetFloatingEyeImageIdentifier getIdentifier(AnjiNet net, Surface surface) {
        int imgWidth = surface.getWidth();
        int imgHeight = surface.getHeight();
        double minZoom = (double)this.eyeDim / (double)Math.min(imgWidth, imgHeight);
        int numSteps = this.evalFactor > 0 ? (int)Math.round((double)this.evalFactor / (double)net.cost()) : this.evalSteps;
        AnjiNetFloatingEyeImageIdentifier result2 = new AnjiNetFloatingEyeImageIdentifier(net, surface, this.eyeDim, new EyeMovementParms(minZoom, this.eyeStartZoom, this.flipEnabled, this.maxXPerStep, this.maxYPerStep, this.maxZPerStep, this.maxThetaPerStep), this.doDisplay, numSteps);
        result2.setStepSleepMillis(this.stepSleepMillis);
        return result2;
    }
}

