/*
 * Decompiled with CFR 0.152.
 */
package com.anji.floatingeye;

import com.anji.floatingeye.AnjiNetFloatingEye;
import com.anji.floatingeye.CompositeAffinityListener;
import com.anji.floatingeye.EyeMovementParms;
import com.anji.floatingeye.FloatingEyeDisplay;
import com.anji.floatingeye.WeightedAffinityListener;
import com.anji.imaging.DoubleLocation2D;
import com.anji.imaging.Identifier;
import com.anji.imaging.Java2DSurface;
import com.anji.imaging.Surface;
import com.anji.nn.AnjiNet;
import com.anji.nn.StepHourglassConnection;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

class AnjiNetFloatingEyeImageIdentifier
implements Identifier {
    private static Logger logger = Logger.getLogger(AnjiNetFloatingEyeImageIdentifier.class);
    private AnjiNetFloatingEye eye;
    private WeightedAffinityListener weightedAffinityListener = new WeightedAffinityListener();
    private FloatingEyeDisplay display;
    private StepHourglassConnection hourglassConnection = new StepHourglassConnection();
    private long stepSleepMillis;
    private Surface surface;
    private int numSteps;

    AnjiNetFloatingEyeImageIdentifier(AnjiNet aNet, Surface aSurface, int anEyeDim, EyeMovementParms aMovementParms, boolean doDisplay, int aNumSteps) {
        this.surface = aSurface;
        CompositeAffinityListener compositeListener = new CompositeAffinityListener();
        compositeListener.add(this.weightedAffinityListener);
        ArrayList<StepHourglassConnection> additionalInputConns = new ArrayList<StepHourglassConnection>(1);
        additionalInputConns.add(this.hourglassConnection);
        this.eye = new AnjiNetFloatingEye(aNet, this.surface, anEyeDim, aMovementParms, compositeListener, additionalInputConns);
        if (doDisplay) {
            this.display = new FloatingEyeDisplay((Java2DSurface)aSurface, this.eye.getFloatingEye());
            this.display.setVisible(true);
            compositeListener.add(this.display);
        }
        this.stepSleepMillis = 0L;
        this.numSteps = aNumSteps;
    }

    @Override
    public float identify(File imgFile) throws IOException {
        this.surface.setImage(imgFile);
        this.weightedAffinityListener.reset(this.numSteps);
        this.hourglassConnection.reset(this.numSteps);
        this.eye.reset();
        int i = 0;
        while (i < this.numSteps) {
            this.eye.step();
            if (this.display != null) {
                StringBuffer status = new StringBuffer();
                status.append("cost=").append(this.eye.cost()).append("\t# steps=").append(this.eye.getStepNum()).append("/").append(this.numSteps).append("\timg=").append(imgFile.getName()).append("\n").append(this.eye.toString()).append("\nweighted affinity=").append(DoubleLocation2D.TO_STRING_FORMAT.format(this.weightedAffinityListener.getWeightedAffinity()));
                String statusStr = status.toString();
                this.display.setStatus(statusStr);
                this.display.repaint();
                try {
                    Thread.sleep(this.stepSleepMillis);
                }
                catch (InterruptedException e) {
                    logger.warn("sleep interrupted", e);
                }
            }
            this.hourglassConnection.step();
            ++i;
        }
        return (float)this.weightedAffinityListener.getWeightedAffinity();
    }

    @Override
    public void dispose() {
        if (this.display != null) {
            this.display.setVisible(false);
            this.display.dispose();
        }
    }

    @Override
    public int getStepNum() {
        return this.eye.getStepNum();
    }

    @Override
    public long cost() {
        return this.eye.cost();
    }

    public void setStepSleepMillis(long aStepSleepMillis) {
        this.stepSleepMillis = aStepSleepMillis;
    }
}

