/*
 * Decompiled with CFR 0.152.
 */
package com.anji.floatingeye;

import org.apache.log4j.Logger;

public class EyeMovementParms {
    private static Logger logger = Logger.getLogger(EyeMovementParms.class);
    private double startZoom;
    private double minZoom;
    private double maxXMovePerStep;
    private double maxYMovePerStep;
    private double maxZMovePerStep;
    private double maxThetaMovePerStep;
    private boolean flipEnabled;

    public EyeMovementParms(double aMinZoom) {
        this(aMinZoom, aMinZoom, true);
    }

    public EyeMovementParms(double aMinZoom, double aStartZoom, boolean aFlipEnabled) {
        this(aMinZoom, aStartZoom, aFlipEnabled, 1.0, 1.0, 1.0, 1.0);
    }

    public EyeMovementParms(double aMinZoom, double aStartZoom, boolean aFlipEnabled, double aMaxXMovePerStep, double aMaxYMovePerStep, double aMaxZMovePerStep, double aMaxThetaMovePerStep) {
        if (aMinZoom <= 0.0 || aMinZoom > 1.0) {
            throw new IllegalArgumentException("zoom factor must be > 0 and <= 1: " + aMinZoom);
        }
        this.minZoom = aMinZoom;
        this.startZoom = aStartZoom;
        if (this.startZoom < this.minZoom) {
            logger.warn("start zoom " + this.startZoom + " < min zoom " + this.minZoom + ": changing start zoom to " + this.minZoom);
            this.startZoom = this.minZoom;
        } else if (this.startZoom > 1.0) {
            logger.warn("start zoom > 1.0: changing start zoom to 1.0");
            this.startZoom = 1.0;
        }
        this.flipEnabled = aFlipEnabled;
        this.maxXMovePerStep = aMaxXMovePerStep;
        this.maxYMovePerStep = aMaxYMovePerStep;
        this.maxZMovePerStep = aMaxZMovePerStep;
        this.maxThetaMovePerStep = aMaxThetaMovePerStep;
    }

    public synchronized boolean isFlipEnabled() {
        return this.flipEnabled;
    }

    public synchronized double getMaxThetaMovePerStep() {
        return this.maxThetaMovePerStep;
    }

    public synchronized double getMaxXMovePerStep() {
        return this.maxXMovePerStep;
    }

    public synchronized double getMaxYMovePerStep() {
        return this.maxYMovePerStep;
    }

    public synchronized double getMaxZMovePerStep() {
        return this.maxZMovePerStep;
    }

    public synchronized double getMinZoom() {
        return this.minZoom;
    }

    public synchronized double getStartZoom() {
        return this.startZoom;
    }
}

