/*
 * Decompiled with CFR 0.152.
 */
package com.anji.floatingeye;

import com.anji.floatingeye.FloatingEye;
import com.anji.nn.Connection;

public class EyePixelConnection
implements Connection {
    private int x;
    private int y;
    private FloatingEye eye;

    public EyePixelConnection(int anX, int aY, FloatingEye anEye) {
        if (anX < 0 || aY < 0 || anX >= anEye.getWidth() || aY >= anEye.getHeight()) {
            throw new IllegalArgumentException("invalid coordinate for eye pixel: (" + anX + ", " + aY + ")");
        }
        this.x = anX;
        this.y = aY;
        this.eye = anEye;
    }

    @Override
    public double read() {
        int rawPixel = this.eye.getEyePixel(this.x, this.y);
        int byte1 = ((rawPixel & 0xFF000000) >>> 24) - 255;
        int byte2 = 255 - ((rawPixel & 0xFF0000) >>> 16);
        int adjustedPixel = byte1 == 0 ? byte2 : byte1;
        double result2 = (double)adjustedPixel / 255.0;
        return result2;
    }

    @Override
    public String toXml() {
        StringBuffer result2 = new StringBuffer();
        result2.append("<").append("connection");
        result2.append("\" from-eye-x=\"").append(this.x);
        result2.append("\" from-eye-y=\"").append(this.y).append("\" />");
        return result2.toString();
    }

    @Override
    public long cost() {
        return 821L;
    }
}

