/*
 * Decompiled with CFR 0.152.
 */
package com.anji.floatingeye;

import com.anji.floatingeye.EyeMovementParms;
import com.anji.floatingeye.FloatingLocation;
import com.anji.imaging.DoubleLocation2D;
import com.anji.imaging.IntLocation2D;
import com.anji.imaging.RangeTranslator;
import com.anji.imaging.RangeTranslatorFactory;
import com.anji.imaging.Surface;
import com.anji.imaging.TransformParameters;
import com.anji.nn.Neuron;
import com.anji.util.XmlPersistable;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.util.List;
import org.apache.log4j.Logger;

public class FloatingEye
implements XmlPersistable {
    private static Logger logger = Logger.getLogger(FloatingEye.class);
    private static final String XML_TAG = "eye";
    private int stepNum;
    private String name;
    private EyeMovementParms movementParms;
    FloatingLocation eyeLocation = new FloatingLocation();
    double eyeRotation;
    boolean eyeLocationXDirty;
    boolean eyeLocationYDirty;
    boolean eyeLocationZDirty;
    boolean flipDirty;
    private boolean eyeRotationDirty;
    private Surface surface;
    private boolean surfaceDirty;
    int[] eyePixels;
    private int eyeWidth;
    private int eyeHeight;
    private Neuron eyeLocationXControlNeuron;
    private Neuron eyeLocationYControlNeuron;
    private Neuron eyeLocationZControlNeuron;
    private Neuron eyeRotationControlNeuron;
    private RangeTranslator eyeLocationXControlTranslator;
    private RangeTranslator eyeLocationYControlTranslator;
    private RangeTranslator eyeLocationZControlTranslator;
    private RangeTranslator eyeRotationControlTranslator;
    private RangeTranslator eyeRotationInputToRadiansTranslator;

    public FloatingEye(String aName, List controlNeurons, Surface aSurface, int anEyeDim, EyeMovementParms someMovementParms) {
        if (anEyeDim < 1) {
            throw new IllegalArgumentException("eye dimensions must be >= 1: " + anEyeDim);
        }
        int controlNeuronCount = 0;
        this.movementParms = someMovementParms;
        if (this.movementParms.getMaxXMovePerStep() > 0.0) {
            ++controlNeuronCount;
        }
        if (this.movementParms.getMaxYMovePerStep() > 0.0) {
            ++controlNeuronCount;
        }
        if (this.movementParms.getMaxZMovePerStep() > 0.0) {
            ++controlNeuronCount;
        }
        if (this.movementParms.getMaxThetaMovePerStep() > 0.0) {
            ++controlNeuronCount;
        }
        if (controlNeurons.size() < controlNeuronCount) {
            throw new IllegalArgumentException("# control neurons must be >= 4: " + controlNeurons.size());
        }
        this.eyeWidth = anEyeDim;
        this.eyeHeight = anEyeDim;
        this.eyePixels = new int[this.eyeWidth * this.eyeHeight];
        this.name = aName;
        this.surface = aSurface;
        this.surfaceDirty = true;
        this.eyeRotationInputToRadiansTranslator = RangeTranslatorFactory.getInstance().getTranslator(-1.0, 1.0, -Math.PI, Math.PI);
        this.connectToControlNeurons(controlNeurons);
        this.reset();
    }

    private boolean isFlipped() {
        return this.movementParms.isFlipEnabled() && this.eyeLocation.z < 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String toXml() {
        StringBuffer result2 = new StringBuffer();
        result2.append("<").append(XML_TAG).append(">\n\t<position x=\"");
        FloatingEye floatingEye = this;
        synchronized (floatingEye) {
            result2.append(this.eyeLocation.x);
            result2.append("\" y=\"").append(this.eyeLocation.y);
            result2.append("\" z=\"").append(this.eyeLocation.z);
            result2.append("\" />\n\t<eye-image>\n");
            int x = 0;
            while (x < this.eyeWidth) {
                int y = 0;
                while (y < this.eyeHeight) {
                    result2.append("\t\t<pixel x=\"").append(x);
                    result2.append("\" y=\"").append(y).append("\">");
                    result2.append("</pixel>\n");
                    ++y;
                }
                ++x;
            }
        }
        result2.append("\t</eye-image>\n</").append(XML_TAG).append(">\n");
        return result2.toString();
    }

    public String toString() {
        StringBuffer result2 = new StringBuffer();
        result2.append(this.name).append(": ").append(this.eyeLocation.toString()).append(": theta=").append(DoubleLocation2D.TO_STRING_FORMAT.format(this.getEyeDirectionRadians()));
        return result2.toString();
    }

    public synchronized void reset() {
        this.eyeLocation.x = 0.0;
        this.eyeLocation.y = 0.0;
        this.eyeLocation.z = 1.0 - this.movementParms.getStartZoom();
        this.eyeRotation = 0.0;
        this.eyeLocationXDirty = true;
        this.eyeLocationYDirty = true;
        this.eyeLocationZDirty = true;
        this.flipDirty = true;
        this.eyeRotationDirty = true;
        this.stepNum = 0;
    }

    private void connectToControlNeurons(List controlNeurons) {
        RangeTranslatorFactory factory = RangeTranslatorFactory.getInstance();
        int outputIdx = 0;
        if (this.movementParms.getMaxXMovePerStep() > 0.0) {
            this.eyeLocationXControlNeuron = (Neuron)controlNeurons.get(outputIdx++);
            this.eyeLocationXControlTranslator = factory.getTranslator(this.eyeLocationXControlNeuron.getFunc().getMinValue(), this.eyeLocationXControlNeuron.getFunc().getMaxValue(), -1.0, 1.0);
        }
        if (this.movementParms.getMaxYMovePerStep() > 0.0) {
            this.eyeLocationYControlNeuron = (Neuron)controlNeurons.get(outputIdx++);
            this.eyeLocationYControlTranslator = factory.getTranslator(this.eyeLocationYControlNeuron.getFunc().getMinValue(), this.eyeLocationYControlNeuron.getFunc().getMaxValue(), -1.0, 1.0);
        }
        if (this.movementParms.getMaxZMovePerStep() > 0.0) {
            this.eyeLocationZControlNeuron = (Neuron)controlNeurons.get(outputIdx++);
            this.eyeLocationZControlTranslator = factory.getTranslator(this.eyeLocationZControlNeuron.getFunc().getMinValue(), this.eyeLocationZControlNeuron.getFunc().getMaxValue(), -1.0, 1.0);
        }
        if (this.movementParms.getMaxThetaMovePerStep() > 0.0) {
            this.eyeRotationControlNeuron = (Neuron)controlNeurons.get(outputIdx++);
            this.eyeRotationControlTranslator = factory.getTranslator(this.eyeRotationControlNeuron.getFunc().getMinValue(), this.eyeRotationControlNeuron.getFunc().getMaxValue(), -1.0, 1.0);
        }
        if (controlNeurons.size() != outputIdx) {
            logger.warn(String.valueOf(this.name) + ": FloatingEye did not use all outputs");
        }
    }

    public synchronized double getZoom() {
        return Math.max(1.0 - Math.abs(this.eyeLocation.z), this.movementParms.getMinZoom());
    }

    public int getWidth() {
        return this.eyeWidth;
    }

    public int getHeight() {
        return this.eyeHeight;
    }

    public synchronized IntLocation2D getSurfaceLocation() {
        int width = this.surface.getWidth();
        int height = this.surface.getHeight();
        IntLocation2D result2 = new IntLocation2D();
        result2.x = Math.min((int)((this.eyeLocation.x + 1.0) / 2.0 * (double)width), width - 1);
        result2.y = Math.min((int)((this.eyeLocation.y + 1.0) / 2.0 * (double)height), height - 1);
        return result2;
    }

    private synchronized boolean isEyeImageDirty() {
        return this.surfaceDirty || this.eyeLocationXDirty || this.eyeLocationYDirty || this.eyeLocationZDirty || this.eyeRotationDirty;
    }

    private synchronized void setEyeImageClean() {
        this.surfaceDirty = false;
        this.eyeLocationXDirty = false;
        this.eyeLocationYDirty = false;
        this.eyeLocationZDirty = false;
        this.eyeRotationDirty = false;
        this.flipDirty = false;
    }

    private synchronized void loadEyeImage() {
        if (this.isEyeImageDirty()) {
            try {
                IntLocation2D surfaceLocation = this.getSurfaceLocation();
                double zoom = this.getZoom();
                int xCenter = this.surface.getWidth() / 2;
                int yCenter = this.surface.getHeight() / 2;
                TransformParameters parms = new TransformParameters(xCenter - surfaceLocation.x, yCenter - surfaceLocation.y, -this.eyeRotationInputToRadiansTranslator.translate(this.eyeRotation), zoom, zoom, this.eyeWidth, this.eyeHeight, this.isFlipped());
                this.eyePixels = this.surface.transform(parms);
                this.setEyeImageClean();
            }
            catch (RasterFormatException e) {
                logger.error("error transforming eye: " + this.toString(), e);
                throw e;
            }
        }
    }

    private double nextLocation(double currentLocation, double rawControlValue, RangeTranslator rangeXlator, double maxMovePerStep) {
        double controlValue = rangeXlator.translate(rawControlValue);
        double newLocation = currentLocation + controlValue * maxMovePerStep;
        return Math.min(Math.max(newLocation, -1.0), 1.0);
    }

    private synchronized void updatePosition() {
        double lastX = this.eyeLocation.x;
        double lastY = this.eyeLocation.y;
        double lastZ = this.eyeLocation.z;
        double lastDirection = this.eyeRotation;
        if (this.movementParms.getMaxXMovePerStep() > 0.0) {
            this.eyeLocation.x = this.nextLocation(this.eyeLocation.x, this.eyeLocationXControlNeuron.getValue(), this.eyeLocationXControlTranslator, this.movementParms.getMaxXMovePerStep());
        }
        if (this.movementParms.getMaxYMovePerStep() > 0.0) {
            this.eyeLocation.y = this.nextLocation(this.eyeLocation.y, this.eyeLocationYControlNeuron.getValue(), this.eyeLocationYControlTranslator, this.movementParms.getMaxYMovePerStep());
        }
        if (this.movementParms.getMaxZMovePerStep() > 0.0) {
            this.eyeLocation.z = this.nextLocation(this.eyeLocation.z, this.eyeLocationZControlNeuron.getValue(), this.eyeLocationZControlTranslator, this.movementParms.getMaxZMovePerStep());
        }
        if (!this.movementParms.isFlipEnabled()) {
            this.eyeLocation.z = Math.max(this.eyeLocation.z, 0.0);
        }
        if (this.movementParms.getMaxThetaMovePerStep() > 0.0) {
            this.eyeRotation = this.nextLocation(this.eyeRotation, this.eyeRotationControlNeuron.getValue(), this.eyeRotationControlTranslator, this.movementParms.getMaxThetaMovePerStep());
        }
        this.eyeLocationZDirty = this.eyeLocation.z != lastZ;
        this.eyeLocationXDirty = this.eyeLocationZDirty || this.eyeLocation.x != lastX;
        this.eyeLocationYDirty = this.eyeLocationZDirty || this.eyeLocation.y != lastY;
        this.eyeRotationDirty = this.eyeRotation != lastDirection;
        this.flipDirty = this.eyeLocation.z >= 0.0 && lastZ < 0.0 || this.eyeLocation.z < 0.0 && lastZ >= 0.0;
    }

    public void step(int count) {
        int i = 0;
        while (i < count) {
            this.step();
            ++i;
        }
    }

    public void step() {
        ++this.stepNum;
        this.loadEyeImage();
        this.updatePosition();
    }

    synchronized void setSurfaceDirty(boolean aSurfaceDirty) {
        this.surfaceDirty = aSurfaceDirty;
    }

    public synchronized FloatingLocation getEyeLocation() {
        return this.eyeLocation;
    }

    public synchronized double getEyeDirectionRadians() {
        return this.eyeRotationInputToRadiansTranslator.translate(this.eyeRotation);
    }

    public synchronized Image getEyeImage() {
        BufferedImage img = new BufferedImage(this.eyeWidth, this.eyeHeight, 2);
        int x = 0;
        while (x < this.eyeWidth) {
            int y = 0;
            while (y < this.eyeHeight) {
                img.setRGB(x, y, this.getEyePixel(x, y));
                ++y;
            }
            ++x;
        }
        return img;
    }

    public synchronized int getStepNum() {
        return this.stepNum;
    }

    public synchronized int getEyePixel(int x, int y) {
        return this.eyePixels[x + y * this.eyeWidth];
    }

    @Override
    public String getXmlRootTag() {
        return XML_TAG;
    }

    @Override
    public String getXmld() {
        return this.name;
    }
}

