/*
 * Decompiled with CFR 0.152.
 */
package com.anji.floatingeye;

import com.anji.floatingeye.AffinityListener;
import com.anji.floatingeye.EyeCanvas;
import com.anji.floatingeye.FloatingEye;
import com.anji.floatingeye.SurfaceCanvas;
import com.anji.imaging.IntLocation2D;
import com.anji.imaging.Java2DSurface;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class FloatingEyeDisplay
extends JFrame
implements AffinityListener {
    private static final String NAME = "Floating Eye Display";
    private TextArea statusArea;
    private FloatingEye eye;
    private Canvas surfaceCanvas;
    private Canvas eyeCanvas;
    private XYSeries affinitySeries = new XYSeries((Comparable)((Object)"affinityValue"));
    private static final int IMG_WIDTH = 150;
    private static final int IMG_HEIGHT = 150;

    @Override
    public void repaint() {
        super.repaint();
        this.statusArea.repaint();
        this.surfaceCanvas.repaint();
        this.eyeCanvas.repaint();
    }

    public FloatingEyeDisplay(Java2DSurface aSurface, FloatingEye anEye) {
        super(NAME);
        this.init(aSurface, anEye);
    }

    private void init(Java2DSurface surface, FloatingEye anEye) {
        this.eye = anEye;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FloatingEyeDisplay.this.setVisible(false);
                FloatingEyeDisplay.this.dispose();
            }
        });
        GridLayout mainLayout = new GridLayout(2, 1);
        mainLayout.setHgap(10);
        mainLayout.setVgap(10);
        this.getContentPane().setLayout(mainLayout);
        GridLayout topPanelLayout = new GridLayout(2, 1);
        topPanelLayout.setHgap(10);
        topPanelLayout.setVgap(10);
        Panel topPanel = new Panel(topPanelLayout);
        GridLayout bottomPanelLayout = new GridLayout(1, 2);
        bottomPanelLayout.setHgap(10);
        bottomPanelLayout.setVgap(10);
        Panel bottomPanel = new Panel(bottomPanelLayout);
        this.statusArea = new TextArea("", 1, 1, 1);
        this.statusArea.setEditable(false);
        this.statusArea.setFont(new Font("Dialog", 0, 10));
        this.statusArea.setSize(new Dimension(300, 75));
        XYSeriesCollection seriesCollection = new XYSeriesCollection(this.affinitySeries);
        JFreeChart chart = ChartFactory.createXYLineChart("affinity history", "step", "affinity", seriesCollection, PlotOrientation.VERTICAL, false, false, false);
        ValueAxis rangeAxis = chart.getXYPlot().getRangeAxis();
        rangeAxis.setAutoRange(false);
        rangeAxis.setRange(0.0, 1.0);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(300, 75));
        this.surfaceCanvas = new SurfaceCanvas(surface, this.eye, 150, 150);
        this.surfaceCanvas.setBackground(Color.WHITE);
        this.eyeCanvas = new EyeCanvas(this.eye, 150, 150);
        this.eyeCanvas.setBackground(Color.WHITE);
        topPanel.add(this.statusArea);
        topPanel.add(chartPanel);
        bottomPanel.add(this.surfaceCanvas);
        bottomPanel.add(this.eyeCanvas);
        this.getContentPane().add(topPanel);
        this.getContentPane().add(bottomPanel);
        this.pack();
    }

    public void setStatus(String s) {
        this.statusArea.setText(s);
    }

    @Override
    public void updateAffinity(IntLocation2D aPos, double aValue) {
        this.affinitySeries.add((double)this.affinitySeries.getItemCount(), aValue);
    }

    @Override
    public void reset() {
        this.affinitySeries.clear();
    }

    @Override
    public String toString() {
        return NAME;
    }
}

