/*
 * Decompiled with CFR 0.152.
 */
package com.anji.floatingeye;

import com.anji.floatingeye.FloatingEye;
import com.anji.imaging.IntLocation2D;
import com.anji.imaging.Java2DSurface;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;

public class SurfaceCanvas
extends Canvas {
    private Java2DSurface canvasSurface;
    private FloatingEye eye;
    private double surfaceToCanvasScaleFactorX;
    private double surfaceToCanvasScaleFactorY;
    private AffineTransformOp surfaceXformOp;

    public SurfaceCanvas(Java2DSurface aSurface, FloatingEye anEye, int canvasWidth, int canvasHeight) {
        this.canvasSurface = aSurface;
        this.eye = anEye;
        this.surfaceToCanvasScaleFactorX = (double)canvasWidth / (double)this.canvasSurface.getWidth();
        this.surfaceToCanvasScaleFactorY = (double)canvasHeight / (double)this.canvasSurface.getHeight();
        AffineTransform xform = AffineTransform.getScaleInstance(this.surfaceToCanvasScaleFactorX, this.surfaceToCanvasScaleFactorY);
        this.surfaceXformOp = new AffineTransformOp(xform, 1);
        this.setSize(canvasWidth, canvasHeight);
    }

    private IntLocation2D calculatePointOnCircle(IntLocation2D center, double radius, double theta) {
        double x = radius * Math.cos(theta);
        double y = radius * Math.sin(theta);
        x += (double)center.x;
        y += (double)center.y;
        return new IntLocation2D((int)Math.round(x *= this.surfaceToCanvasScaleFactorX), (int)Math.round(y *= this.surfaceToCanvasScaleFactorY));
    }

    @Override
    public void paint(Graphics g) {
        Color origColor = g.getColor();
        BufferedImage img = this.surfaceXformOp.filter(this.canvasSurface.getBufferedImage(), null);
        g.drawImage(img, 0, 0, null);
        int halfHeight = (int)Math.round((double)this.eye.getWidth() / this.eye.getZoom() / 2.0);
        int halfWidth = (int)Math.round((double)this.eye.getHeight() / this.eye.getZoom() / 2.0);
        double corner1thetaStart = Math.atan(halfWidth / halfHeight);
        double halfDiagonal = Math.sqrt(halfWidth * halfWidth + halfHeight * halfHeight);
        double corner1theta = corner1thetaStart + this.eye.getEyeDirectionRadians();
        double corner2theta = corner1theta + 1.5707963267948966;
        double corner3theta = corner2theta + 1.5707963267948966;
        double corner4theta = corner3theta + 1.5707963267948966;
        double centerTopTheta = corner3theta + 0.7853981633974483;
        IntLocation2D eyeLocation = this.eye.getSurfaceLocation();
        IntLocation2D corner1 = this.calculatePointOnCircle(eyeLocation, halfDiagonal, corner1theta);
        IntLocation2D corner2 = this.calculatePointOnCircle(eyeLocation, halfDiagonal, corner2theta);
        IntLocation2D corner3 = this.calculatePointOnCircle(eyeLocation, halfDiagonal, corner3theta);
        IntLocation2D corner4 = this.calculatePointOnCircle(eyeLocation, halfDiagonal, corner4theta);
        IntLocation2D center = this.calculatePointOnCircle(eyeLocation, 0.0, centerTopTheta);
        IntLocation2D centerTop = this.calculatePointOnCircle(eyeLocation, halfHeight, centerTopTheta);
        g.setColor(Color.BLUE);
        int[] xPoints = new int[]{corner4.x, corner1.x, corner2.x, corner3.x};
        int[] yPoints = new int[]{corner4.y, corner1.y, corner2.y, corner3.y};
        g.drawPolygon(xPoints, yPoints, 4);
        xPoints = new int[]{center.x, centerTop.x};
        yPoints = new int[]{center.y, centerTop.y};
        g.drawPolyline(xPoints, yPoints, 2);
        g.setColor(origColor);
    }
}

