/*
 * Decompiled with CFR 0.152.
 */
package com.anji.floatingeye;

import com.anji.floatingeye.AffinityListener;
import com.anji.imaging.IntLocation2D;
import java.util.Arrays;

public class WeightedAffinityListener
implements AffinityListener {
    private int stepNumber = 0;
    private double[] affinities = new double[0];

    public synchronized void reset(int numSteps) {
        this.affinities = new double[numSteps];
        this.reset();
    }

    @Override
    public synchronized void updateAffinity(IntLocation2D pos, double value) {
        if (this.stepNumber >= this.affinities.length) {
            throw new IllegalArgumentException("stepped past end of weighted affinities array");
        }
        this.affinities[this.stepNumber] = value;
        ++this.stepNumber;
    }

    public synchronized double getWeightedAffinity() {
        double runningTotal = 0.0;
        int runningMax = 0;
        int i = 0;
        while (i < this.stepNumber) {
            runningTotal += this.affinities[i] * (double)i * (double)i;
            runningMax += i * i;
            ++i;
        }
        return runningTotal / (double)runningMax;
    }

    @Override
    public synchronized void reset() {
        this.stepNumber = 0;
        Arrays.fill(this.affinities, 0.0);
    }

    public String toString() {
        return String.valueOf(this.getWeightedAffinity()) + " [weighted]";
    }
}

