/*
 * Decompiled with CFR 0.152.
 */
package com.anji.gomoku;

import com.anji.ttt.Board;
import org.apache.log4j.Logger;

public class GomokuBoard
implements Board {
    private static Logger logger = Logger.getLogger(GomokuBoard.class);
    private int[] boardState;
    private int boardSize;

    @Override
    public int getBoardSize() {
        return this.boardSize;
    }

    public GomokuBoard(int aSize) {
        this.boardSize = aSize;
        this.boardState = new int[this.boardSize * this.boardSize];
    }

    @Override
    public void initializeBoard() {
        int i = 0;
        while (i < this.boardState.length) {
            this.boardState[i] = 0;
            ++i;
        }
    }

    @Override
    public boolean checkLegalMove(int newMove) {
        return this.boardState[newMove] == 0;
    }

    @Override
    public void updateBoard(int newMove) {
        this.boardState[newMove] = 1;
    }

    @Override
    public boolean checkForWin() {
        int fiveSpaceTotal;
        int groupsToCheck;
        int startPointY;
        int startPointX;
        int fiveSpaceTotal2;
        int groupsToCheck2;
        int startPoint;
        boolean wonGame = false;
        int[][] matrixBoardState = new int[15][15];
        int boardIdx = 0;
        int i = 0;
        while ((double)i < Math.sqrt(this.boardState.length)) {
            int j = 0;
            while ((double)j < Math.sqrt(this.boardState.length)) {
                matrixBoardState[i][j] = this.boardState[boardIdx];
                ++boardIdx;
                ++j;
            }
            ++i;
        }
        i = 0;
        while ((double)i < Math.sqrt(this.boardState.length)) {
            startPoint = 0;
            groupsToCheck2 = 0;
            while (groupsToCheck2 < 11) {
                fiveSpaceTotal2 = 0;
                int j = 0;
                while (j < 5) {
                    fiveSpaceTotal2 += matrixBoardState[i][startPoint + j];
                    ++j;
                }
                if (fiveSpaceTotal2 == 5) {
                    wonGame = true;
                }
                ++startPoint;
                ++groupsToCheck2;
            }
            ++i;
        }
        int j = 0;
        while ((double)j < Math.sqrt(this.boardState.length)) {
            startPoint = 0;
            groupsToCheck2 = 0;
            while ((double)groupsToCheck2 < Math.sqrt(this.boardState.length) - 4.0) {
                fiveSpaceTotal2 = 0;
                int i2 = 0;
                while (i2 < 5) {
                    fiveSpaceTotal2 += matrixBoardState[startPoint + i2][j];
                    ++i2;
                }
                if (fiveSpaceTotal2 == 5) {
                    wonGame = true;
                }
                ++startPoint;
                ++groupsToCheck2;
            }
            ++j;
        }
        i = 0;
        while (i < 11) {
            startPointX = 0;
            startPointY = 0;
            groupsToCheck = 0;
            while (groupsToCheck < 11) {
                fiveSpaceTotal = 0;
                startPointX = 0;
                int j2 = 0;
                while (j2 < 5) {
                    fiveSpaceTotal += matrixBoardState[startPointX + i][startPointY + j2];
                    ++startPointX;
                    ++j2;
                }
                if (fiveSpaceTotal == 5) {
                    wonGame = true;
                }
                ++startPointY;
                ++groupsToCheck;
            }
            ++i;
        }
        j = 0;
        while (j < 11) {
            startPointX = 14;
            startPointY = 0;
            groupsToCheck = 0;
            while (groupsToCheck < 11) {
                fiveSpaceTotal = 0;
                startPointY = 0;
                int i3 = 0;
                while (i3 < 5) {
                    fiveSpaceTotal += matrixBoardState[startPointX - i3][startPointY + j];
                    ++startPointY;
                    ++i3;
                }
                if (fiveSpaceTotal == 5) {
                    wonGame = true;
                }
                --startPointX;
                ++groupsToCheck;
            }
            ++j;
        }
        return wonGame;
    }

    @Override
    public boolean checkForTie() {
        boolean tieGame = false;
        boolean boardFull = true;
        int i = 0;
        while (i < this.boardState.length) {
            if (this.boardState[i] == 0) {
                boardFull = false;
            }
            ++i;
        }
        if (boardFull) {
            tieGame = true;
            logger.debug("tie");
        }
        return tieGame;
    }

    @Override
    public String displayBoard() {
        StringBuffer result2 = new StringBuffer();
        int i = 0;
        while (i < this.boardState.length) {
            if (this.boardState[i] == -1) {
                result2.append(" ");
            }
            result2.append(this.boardState[i]);
            if ((double)(i + 1) % Math.sqrt(this.boardState.length) == 0.0) {
                result2.append("\n");
            }
            ++i;
        }
        result2.append("\n\n");
        return result2.toString();
    }

    @Override
    public int[] getBoardState() {
        return this.boardState;
    }

    @Override
    public void swap() {
        int i = 0;
        while (i < this.boardState.length) {
            this.boardState[i] = this.boardState[i] * -1;
            ++i;
        }
    }
}

