/*
 * Decompiled with CFR 0.152.
 */
package com.anji.gomoku;

import com.anji.gomoku.GomokuBoard;
import com.anji.tournament.Game;
import com.anji.tournament.GameConfiguration;
import com.anji.tournament.GameResults;
import com.anji.tournament.PlayerResults;
import com.anji.tournament.ScoringWeights;
import com.anji.ttt.BoardPlayer;
import com.anji.util.Configurable;
import com.anji.util.Properties;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class GomokuGame
implements Game,
Configurable {
    private static Logger logger = Logger.getLogger(GomokuGame.class);
    private static final int DEFAULT_BOARD_SIZE = 7;
    private int boardSize = 7;
    private GameConfiguration gameConfig = GameConfiguration.DEFAULT;
    private String name = "Gomoku";

    @Override
    public GameResults play(PlayerResults contestantResults, PlayerResults opponentResults) {
        GameResults results = new GameResults();
        BoardPlayer playerOne = (BoardPlayer)contestantResults.getPlayer();
        BoardPlayer playerTwo = (BoardPlayer)opponentResults.getPlayer();
        if (this.gameConfig.doResetPlayers()) {
            playerOne.reset();
            playerTwo.reset();
        }
        boolean gameOver = false;
        int newMove = 0;
        boolean legalMove = false;
        int numMoves = 0;
        StringBuffer gameOneXml = new StringBuffer();
        String playerOneId = playerOne.getPlayerId();
        String playerTwoId = playerTwo.getPlayerId();
        String XML_GAME_TAG = "Gomoku";
        String XML_TYPE_TAG = "GomokuGame";
        String XML_INFORMATION_TAG = "Information";
        String XML_BOARDSIZE_TAG = "BoardSize";
        String XML_COMMENT_TAG = "Comment";
        String MOVE_COLUMN = null;
        int MOVE_ROW = 0;
        int moveColumn = 0;
        GomokuBoard board = new GomokuBoard(this.boardSize);
        board.initializeBoard();
        gameOver = false;
        gameOneXml.append("<").append(XML_GAME_TAG).append(">\n");
        gameOneXml.append("<").append(XML_TYPE_TAG).append(">\n");
        gameOneXml.append("<").append(XML_INFORMATION_TAG).append(">\n");
        gameOneXml.append("<").append(XML_BOARDSIZE_TAG).append(">");
        gameOneXml.append(this.boardSize);
        gameOneXml.append("</").append(XML_BOARDSIZE_TAG).append(">\n");
        gameOneXml.append("</").append(XML_INFORMATION_TAG).append(">\n");
        gameOneXml.append("<").append(XML_COMMENT_TAG).append(">");
        gameOneXml.append(playerOneId).append(" vs. ");
        gameOneXml.append(playerTwoId).append("  \n");
        gameOneXml.append(Calendar.getInstance().getTime());
        gameOneXml.append("</").append(XML_COMMENT_TAG).append(">\n");
        while (!gameOver) {
            legalMove = false;
            MOVE_COLUMN = null;
            MOVE_ROW = 0;
            moveColumn = 0;
            while (!legalMove) {
                newMove = playerOne.move(board.getBoardState());
                legalMove = board.checkLegalMove(newMove);
            }
            moveColumn = newMove % this.boardSize;
            switch (moveColumn) {
                case 0: {
                    MOVE_COLUMN = "A";
                    break;
                }
                case 1: {
                    MOVE_COLUMN = "B";
                    break;
                }
                case 2: {
                    MOVE_COLUMN = "C";
                    break;
                }
                case 3: {
                    MOVE_COLUMN = "D";
                    break;
                }
                case 4: {
                    MOVE_COLUMN = "E";
                    break;
                }
                case 5: {
                    MOVE_COLUMN = "F";
                    break;
                }
                case 6: {
                    MOVE_COLUMN = "G";
                    break;
                }
                case 7: {
                    MOVE_COLUMN = "H";
                    break;
                }
                case 8: {
                    MOVE_COLUMN = "J";
                    break;
                }
                case 9: {
                    MOVE_COLUMN = "K";
                    break;
                }
                case 10: {
                    MOVE_COLUMN = "L";
                    break;
                }
                case 11: {
                    MOVE_COLUMN = "M";
                    break;
                }
                case 12: {
                    MOVE_COLUMN = "N";
                    break;
                }
                case 13: {
                    MOVE_COLUMN = "O";
                    break;
                }
                case 14: {
                    MOVE_COLUMN = "P";
                }
            }
            MOVE_ROW = newMove / this.boardSize + 1;
            gameOneXml.append("<Black at=\"").append(MOVE_COLUMN).append(MOVE_ROW).append("\" />\n");
            ++numMoves;
            board.updateBoard(newMove);
            logger.debug("Player 1:\n" + board.displayBoard());
            if (board.checkForWin()) {
                logger.debug("Player 1 Wins!\n\n");
                results.incrementPlayer1Wins(1);
                gameOver = true;
            } else if (board.checkForTie()) {
                logger.debug("Tie Game!\n\n");
                results.incrementTies(1);
                gameOver = true;
            }
            board.swap();
            if (gameOver) continue;
            legalMove = false;
            MOVE_COLUMN = null;
            MOVE_ROW = 0;
            moveColumn = 0;
            while (!legalMove) {
                newMove = playerTwo.move(board.getBoardState());
                legalMove = board.checkLegalMove(newMove);
            }
            moveColumn = newMove % this.boardSize;
            switch (moveColumn) {
                case 0: {
                    MOVE_COLUMN = "A";
                    break;
                }
                case 1: {
                    MOVE_COLUMN = "B";
                    break;
                }
                case 2: {
                    MOVE_COLUMN = "C";
                    break;
                }
                case 3: {
                    MOVE_COLUMN = "D";
                    break;
                }
                case 4: {
                    MOVE_COLUMN = "E";
                    break;
                }
                case 5: {
                    MOVE_COLUMN = "F";
                    break;
                }
                case 6: {
                    MOVE_COLUMN = "G";
                    break;
                }
                case 7: {
                    MOVE_COLUMN = "H";
                    break;
                }
                case 8: {
                    MOVE_COLUMN = "J";
                    break;
                }
                case 9: {
                    MOVE_COLUMN = "K";
                    break;
                }
                case 10: {
                    MOVE_COLUMN = "L";
                    break;
                }
                case 11: {
                    MOVE_COLUMN = "M";
                    break;
                }
                case 12: {
                    MOVE_COLUMN = "N";
                    break;
                }
                case 13: {
                    MOVE_COLUMN = "O";
                    break;
                }
                case 14: {
                    MOVE_COLUMN = "P";
                }
            }
            MOVE_ROW = newMove / this.boardSize + 1;
            gameOneXml.append("<White at=\"").append(MOVE_COLUMN).append(MOVE_ROW).append("\" />\n");
            ++numMoves;
            board.updateBoard(newMove);
            logger.debug("Player 2:\n" + board.displayBoard());
            if (board.checkForWin()) {
                logger.debug("Player 2 Wins!\n\n");
                results.incrementPlayer1Losses(1);
                gameOver = true;
            } else if (board.checkForTie()) {
                logger.debug("Tie Game!\n\n");
                results.incrementTies(1);
                gameOver = true;
            }
            board.swap();
        }
        gameOneXml.append("</").append(XML_TYPE_TAG).append(">\n");
        gameOneXml.append("</").append(XML_GAME_TAG).append(">\n");
        logger.debug(gameOneXml);
        logger.debug(results.toString());
        if (this.gameConfig.doLogResults()) {
            logger.info(new StringBuffer(this.name).append(": ").append(contestantResults.getPlayer()).append(" vs ").append(opponentResults.getPlayer()).append(": ").append(results).toString());
        }
        contestantResults.getResults().increment(results.getPlayer1Stats());
        opponentResults.getResults().increment(results.getPlayer2Stats());
        return results;
    }

    @Override
    public Class requiredPlayerClass() {
        return BoardPlayer.class;
    }

    @Override
    public int getMaxScore(ScoringWeights aWeights) {
        return aWeights.getWinValue();
    }

    @Override
    public int getMinScore(ScoringWeights aWeights) {
        return aWeights.getLossValue();
    }

    @Override
    public void init(Properties props) throws Exception {
        this.gameConfig = (GameConfiguration)props.singletonObjectProperty(GameConfiguration.class);
        this.name = String.valueOf(this.name) + " " + props.getName();
    }
}

