/*
 * Decompiled with CFR 0.152.
 */
package com.anji.gomoku;

import com.anji.integration.Activator;
import com.anji.ttt.BoardPlayer;

public class GomokuNeuralNetPlayer
implements BoardPlayer {
    private Activator activator;

    public GomokuNeuralNetPlayer(Activator anActivator) {
        this.activator = anActivator;
    }

    @Override
    public String getPlayerId() {
        return this.activator.getName();
    }

    @Override
    public int move(int[] boardState) {
        if (boardState.length + 1 != this.activator.getInputDimension()) {
            throw new IllegalArgumentException("wrong nnet input dimension, board state size = " + boardState.length + " but nnet input is " + this.activator.getInputDimension());
        }
        double[] moveList = new double[boardState.length];
        double[] gomokuInput = new double[boardState.length + 1];
        int i = 0;
        while (i < boardState.length - 1) {
            gomokuInput[i] = boardState[i];
            ++i;
        }
        gomokuInput[boardState.length] = 1.0;
        double[] nnOutput = this.activator.next(gomokuInput);
        i = 0;
        while (i < boardState.length) {
            moveList[i] = nnOutput[i];
            ++i;
        }
        double max = -1.7976931348623157E308;
        int myMove = -1;
        int j = 0;
        while (j < boardState.length) {
            if (boardState[j] == 0 && max <= moveList[j]) {
                myMove = j;
                max = moveList[j];
            }
            ++j;
        }
        return myMove;
    }

    @Override
    public void reset() {
        this.activator.reset();
    }

    public String toString() {
        return this.activator.getName();
    }
}

