/*
 * Decompiled with CFR 0.152.
 */
package com.anji.gomoku;

import com.anji.gomoku.GomokuNeuralNetPlayer;
import com.anji.gomoku.GomokuScanningNeuralNetPlayer;
import com.anji.integration.Activator;
import com.anji.integration.ActivatorTranscriber;
import com.anji.integration.TranscriberException;
import com.anji.tournament.Player;
import com.anji.tournament.PlayerTranscriber;
import com.anji.ttt.BoardPlayer;
import com.anji.util.Configurable;
import com.anji.util.Properties;
import org.jgap.Chromosome;

public class GomokuPlayerTranscriber
implements PlayerTranscriber,
Configurable {
    private static final String TYPE_KEY = "gomoku.player.type";
    private static final String TYPE_DEFAULT = "default";
    private static final String TYPE_SCANNING = "scannnig";
    private ActivatorTranscriber activatorTranscriber;
    private String type = "default";

    @Override
    public Object transcribe(Chromosome c2) throws TranscriberException {
        return this.newPlayer(c2);
    }

    @Override
    public Player newPlayer(Chromosome c2) throws TranscriberException {
        return this.newBoardPlayer(c2);
    }

    public BoardPlayer newBoardPlayer(Chromosome c2) throws TranscriberException {
        Activator activator = this.activatorTranscriber.newActivator(c2);
        if (TYPE_SCANNING.equals(this.type)) {
            return new GomokuScanningNeuralNetPlayer(activator);
        }
        return new GomokuNeuralNetPlayer(activator);
    }

    @Override
    public Class getPhenotypeClass() {
        return BoardPlayer.class;
    }

    @Override
    public void init(Properties props) throws Exception {
        this.activatorTranscriber = (ActivatorTranscriber)props.singletonObjectProperty(ActivatorTranscriber.class);
        this.type = props.getProperty(TYPE_KEY, TYPE_DEFAULT);
    }
}

