/*
 * Decompiled with CFR 0.152.
 */
package com.anji.imaging;

import com.anji.imaging.BufferedImageTransformer;
import com.anji.imaging.TransformParameters;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;

public class AreaAvgBufferedImageTransformer
implements BufferedImageTransformer {
    private BufferedImage data;

    @Override
    public void setImage(BufferedImage anImg) {
        this.data = anImg;
    }

    @Override
    public Image transform(TransformParameters parms) {
        int visibleSurfaceHeight;
        AffineTransform xform = AffineTransform.getTranslateInstance(parms.getTranslateX(), parms.getTranslateY());
        int width = this.data.getWidth();
        int height = this.data.getHeight();
        double centerX = (double)width / 2.0;
        double centerY = (double)height / 2.0;
        if (parms.getRotate() != 0.0) {
            xform.preConcatenate(AffineTransform.getRotateInstance(parms.getRotate(), centerX, centerY));
        }
        if (parms.isFlipHorizontal()) {
            xform.preConcatenate(new AffineTransform(-1.0, 0.0, 0.0, 1.0, (double)width, 0.0));
        }
        AffineTransformOp xformOp = new AffineTransformOp(xform, 1);
        BufferedImage postXform = xformOp.filter(this.data, null);
        int cropX = parms.getCropWidth();
        int cropY = parms.getCropHeight();
        int visibleSurfaceWidth = (int)((double)cropX / parms.getScaleX() + 0.5);
        BufferedImage postCrop = postXform.getSubimage((width - visibleSurfaceWidth + 1) / 2, (height - (visibleSurfaceHeight = (int)((double)cropY / parms.getScaleY() + 0.5)) + 1) / 2, visibleSurfaceWidth, visibleSurfaceHeight);
        if (cropX == postCrop.getWidth() && cropY == postCrop.getHeight()) {
            return postCrop;
        }
        return postCrop.getScaledInstance(cropX, cropY, 16);
    }
}

