/*
 * Decompiled with CFR 0.152.
 */
package com.anji.imaging;

import com.anji.imaging.CardinalDirection;
import com.anji.imaging.CoordinateTranslator;
import com.anji.imaging.IntLocation2D;
import java.util.HashMap;
import java.util.Map;

public class CoordinateTranslatorFactory {
    private static CoordinateTranslatorFactory instance;
    private Map unflippedTransformers = new HashMap();
    private Map flippedTransformers = new HashMap();

    private CoordinateTranslatorFactory() {
        this.unflippedTransformers.put(CardinalDirection.NORTH, new NorthTransformer());
        this.unflippedTransformers.put(CardinalDirection.SOUTH, new SouthTransformer());
        this.unflippedTransformers.put(CardinalDirection.EAST, new EastTransformer());
        this.unflippedTransformers.put(CardinalDirection.WEST, new WestTransformer());
        this.flippedTransformers.put(CardinalDirection.NORTH, new FlippedNorthTransformer());
        this.flippedTransformers.put(CardinalDirection.SOUTH, new FlippedSouthTransformer());
        this.flippedTransformers.put(CardinalDirection.EAST, new FlippedEastTransformer());
        this.flippedTransformers.put(CardinalDirection.WEST, new FlippedWestTransformer());
    }

    public static CoordinateTranslatorFactory getInstance() {
        if (instance == null) {
            instance = new CoordinateTranslatorFactory();
        }
        return instance;
    }

    public CoordinateTranslator getTransformer(boolean flipped, CardinalDirection direction) {
        return flipped ? (CoordinateTranslator)this.flippedTransformers.get(direction) : (CoordinateTranslator)this.unflippedTransformers.get(direction);
    }

    private class EastTransformer
    implements CoordinateTranslator {
        private EastTransformer() {
        }

        public String toString() {
            return "EastTransformer";
        }

        @Override
        public void transform(IntLocation2D coords, int max) {
            int x = coords.x;
            coords.x = max - coords.y;
            coords.y = x;
        }
    }

    private class FlippedEastTransformer
    implements CoordinateTranslator {
        private FlippedEastTransformer() {
        }

        public String toString() {
            return "FlippedEastTransformer";
        }

        @Override
        public void transform(IntLocation2D coords, int max) {
            int x = coords.x;
            coords.x = coords.y;
            coords.y = x;
        }
    }

    private class FlippedNorthTransformer
    implements CoordinateTranslator {
        private FlippedNorthTransformer() {
        }

        public String toString() {
            return "FlippedNorthTransformer";
        }

        @Override
        public void transform(IntLocation2D coords, int max) {
            coords.x = max - coords.x;
        }
    }

    private class FlippedSouthTransformer
    implements CoordinateTranslator {
        private FlippedSouthTransformer() {
        }

        public String toString() {
            return "FlippedSouthTransformer";
        }

        @Override
        public void transform(IntLocation2D coords, int max) {
            coords.y = max - coords.y;
        }
    }

    private class FlippedWestTransformer
    implements CoordinateTranslator {
        private FlippedWestTransformer() {
        }

        public String toString() {
            return "FlippedWestTransformer";
        }

        @Override
        public void transform(IntLocation2D coords, int max) {
            int x = coords.x;
            coords.x = max - coords.y;
            coords.y = max - x;
        }
    }

    private class NorthTransformer
    implements CoordinateTranslator {
        private NorthTransformer() {
        }

        @Override
        public void transform(IntLocation2D coords, int max) {
        }
    }

    private class SouthTransformer
    implements CoordinateTranslator {
        private SouthTransformer() {
        }

        public String toString() {
            return "SouthTransformer";
        }

        @Override
        public void transform(IntLocation2D coords, int max) {
            coords.x = max - coords.x;
            coords.y = max - coords.y;
        }
    }

    private class WestTransformer
    implements CoordinateTranslator {
        private WestTransformer() {
        }

        public String toString() {
            return "WestTransformer";
        }

        @Override
        public void transform(IntLocation2D coords, int max) {
            int x = coords.x;
            coords.x = coords.y;
            coords.y = max - x;
        }
    }
}

