/*
 * Decompiled with CFR 0.152.
 */
package com.anji.imaging;

import com.anji.imaging.BufferedImageTransformer;
import com.anji.imaging.TransformParameters;
import com.anji.util.Configurable;
import com.anji.util.Properties;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;

public class DefaultBufferedImageTransformer
implements BufferedImageTransformer,
Configurable {
    public static final String INTERPOLATION_TYPE_KEY = "image.transform.interpolation.type";
    private static final int DEFAULT_INTERPOLATION_TYPE = 2;
    private BufferedImage data;
    private int centerX;
    private int centerY;
    private int interpolationType = 2;

    @Override
    public void setImage(BufferedImage anImg) {
        this.data = anImg;
        this.centerX = this.data.getWidth() / 2;
        this.centerY = this.data.getHeight() / 2;
    }

    private BufferedImage preCrop(TransformParameters parms) {
        int cropCenterX = this.centerX - parms.getTranslateX();
        int cropCenterY = this.centerY - parms.getTranslateY();
        double invScaleX = 1.0 / parms.getScaleX();
        double invScaleY = 1.0 / parms.getScaleY();
        double factor = Math.abs(Math.cos(parms.getRotate())) + Math.abs(Math.sin(parms.getRotate()));
        int croppedWidth = (int)((double)parms.getCropWidth() * factor * invScaleX + 0.5);
        int croppedHeight = (int)((double)parms.getCropHeight() * factor * invScaleY + 0.5);
        int cropStartX = cropCenterX - croppedWidth / 2;
        int cropStartY = cropCenterY - croppedHeight / 2;
        return this.data.getSubimage(cropStartX, cropStartY, croppedWidth, croppedHeight);
    }

    @Override
    public Image transform(TransformParameters parms) {
        BufferedImage preCropped = this.preCrop(parms);
        AffineTransform xform = new AffineTransform();
        double rotate = parms.getRotate();
        int preCroppedWidth = preCropped.getWidth();
        int preCroppedHeight = preCropped.getHeight();
        double preCroppedCenterX = (double)preCroppedWidth / 2.0;
        double preCroppedCenterY = (double)preCroppedHeight / 2.0;
        if (rotate != 0.0) {
            xform.preConcatenate(AffineTransform.getRotateInstance(rotate, preCroppedCenterX, preCroppedCenterY));
        }
        double scaleX = parms.getScaleX();
        double scaleY = parms.getScaleY();
        if (scaleX != 1.0 || scaleY != 1.0) {
            xform.preConcatenate(AffineTransform.getScaleInstance(scaleX, scaleY));
        }
        if (parms.isFlipHorizontal()) {
            xform.preConcatenate(new AffineTransform(-1.0, 0.0, 0.0, 1.0, (double)preCroppedWidth * scaleX, 0.0));
        }
        AffineTransformOp xformOp = new AffineTransformOp(xform, this.interpolationType);
        BufferedImage postXform = xformOp.filter(preCropped, null);
        int resultWidth = parms.getCropWidth();
        int resultHeight = parms.getCropHeight();
        int startX = (int)(((double)preCroppedWidth * scaleX - (double)resultWidth + 1.0) / 2.0);
        int startY = (int)(((double)preCroppedHeight * scaleY - (double)resultHeight + 1.0) / 2.0);
        return postXform.getSubimage(startX, startY, resultWidth, resultHeight);
    }

    @Override
    public void init(Properties props) throws Exception {
        this.interpolationType = props.getIntProperty(INTERPOLATION_TYPE_KEY, 2);
    }
}

