/*
 * Decompiled with CFR 0.152.
 */
package com.anji.imaging;

import com.anji.floatingeye.AnjiNetFloatingEyeIdentifierFactory;
import com.anji.floatingeye.AnjiNetFloatingEyeImageIdentifier;
import com.anji.imaging.Identifier;
import com.anji.imaging.ImageFileFilter;
import com.anji.imaging.ImageRandomizer;
import com.anji.imaging.Surface;
import com.anji.integration.AnjiNetTranscriber;
import com.anji.integration.ErrorFunction;
import com.anji.integration.ErrorRateCounter;
import com.anji.integration.TranscriberException;
import com.anji.nn.AnjiNet;
import com.anji.util.Configurable;
import com.anji.util.Properties;
import com.anji.util.Randomizer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.jgap.BulkFitnessFunction;
import org.jgap.Chromosome;

public class IdentifyImageFitnessFunction
implements BulkFitnessFunction,
Configurable {
    private File matchDir;
    private File mismatchDir;
    private static Logger logger = Logger.getLogger(IdentifyImageFitnessFunction.class);
    public static final String IMG_MATCH_DIR_KEY = "image.matches";
    public static final String IMG_MISMATCH_DIR_KEY = "image.mismatches";
    public static final String SURFACE_CLASS_KEY = "eye.surface";
    private static final boolean SUM_OF_SQUARES = false;
    public static final int MAX_FITNESS = 1000000;
    private List imgInfos = new ArrayList();
    private ImageRandomizer imgRandomizer;
    private Surface surface;
    private Randomizer randomizer;
    private AnjiNetFloatingEyeIdentifierFactory identifierFactory;
    private AnjiNetTranscriber transcriber;

    @Override
    public void evaluate(List subjects) {
        if (this.imgRandomizer != null) {
            try {
                this.imgRandomizer.transformFiles(this.matchDir, this.mismatchDir);
            }
            catch (IOException e) {
                logger.error("error randomizing image files", e);
                throw new RuntimeException("error randomizing image files", e);
            }
            this.loadImages();
        }
        for (Chromosome c2 : subjects) {
            try {
                c2.setFitnessValue(this.evaluate(c2));
            }
            catch (Throwable e) {
                logger.warn("error evaluating chromosome " + c2.toString(), e);
                c2.setFitnessValue(0);
            }
        }
    }

    public int evaluate(Chromosome c2) throws TranscriberException, IOException {
        double[][] targets = new double[this.imgInfos.size()][1];
        double[][] responses = new double[this.imgInfos.size()][1];
        int idx = 0;
        AnjiNet net = this.transcriber.newAnjiNet(c2);
        long cost = net.cost();
        Collections.shuffle(this.imgInfos, this.randomizer.getRand());
        Iterator it = this.imgInfos.iterator();
        ImageInfo imgInfo = (ImageInfo)it.next();
        this.surface.setImage(imgInfo.file);
        int imgWidth = this.surface.getWidth();
        int imgHeight = this.surface.getHeight();
        AnjiNetFloatingEyeImageIdentifier identifier = this.identifierFactory.getIdentifier(net, this.surface);
        logger.debug(IdentifyImageFitnessFunction.toCostString(cost, identifier.getStepNum()));
        double maxError = ErrorFunction.getInstance().getMaxError(this.imgInfos.size(), 1.0, false);
        double maxRawFitnessValue = Math.pow(maxError, 2.0);
        targets[idx][0] = imgInfo.isMatch ? 1.0 : 0.0;
        double result2 = identifier.identify(imgInfo.file);
        logger.debug(IdentifyImageFitnessFunction.toCategorizationString(imgInfo, new double[]{result2}));
        responses[idx++][0] = result2;
        while (it.hasNext()) {
            imgInfo = (ImageInfo)it.next();
            double d = targets[idx][0] = imgInfo.isMatch ? 1.0 : 0.0;
            if (imgWidth != this.surface.getWidth() || imgHeight != this.surface.getHeight()) {
                throw new IllegalArgumentException("images must all be same dimension: " + imgWidth + ", " + imgHeight + " vs " + this.surface.getWidth() + ", " + this.surface.getHeight());
            }
            result2 = identifier.identify(imgInfo.file);
            logger.debug(IdentifyImageFitnessFunction.toCategorizationString(imgInfo, new double[]{result2}));
            responses[idx++][0] = result2;
        }
        identifier.dispose();
        ErrorRateCounter.getInstance().countErrors("chromosome " + c2.getId().toString(), targets, responses);
        double error = ErrorFunction.getInstance().calculateError(targets, responses, false);
        if (error > maxError) {
            throw new IllegalStateException("error " + error + " > max error " + maxError);
        }
        double rawFitnessValue = Math.pow(maxError - error, 2.0);
        double skewedFitness = rawFitnessValue / maxRawFitnessValue * 1000000.0;
        return (int)skewedFitness;
    }

    public int evaluateEnsemble(Collection ensemble) throws TranscriberException, IOException {
        double[][] targets = new double[this.imgInfos.size()][1];
        double[][] responses = new double[this.imgInfos.size()][1];
        int idx = 0;
        Collections.shuffle(this.imgInfos, this.randomizer.getRand());
        Iterator imgInfoIter = this.imgInfos.iterator();
        ImageInfo imgInfo = (ImageInfo)imgInfoIter.next();
        this.surface.setImage(imgInfo.file);
        int imgWidth = this.surface.getWidth();
        int imgHeight = this.surface.getHeight();
        ArrayList<AnjiNetFloatingEyeImageIdentifier> identifiers = new ArrayList<AnjiNetFloatingEyeImageIdentifier>();
        for (Chromosome c2 : ensemble) {
            AnjiNet net = this.transcriber.newAnjiNet(c2);
            AnjiNetFloatingEyeImageIdentifier identifier = this.identifierFactory.getIdentifier(net, this.surface);
            identifiers.add(identifier);
        }
        double maxError = ErrorFunction.getInstance().getMaxError(this.imgInfos.size(), 1.0, false);
        double maxRawFitnessValue = Math.pow(maxError, 2.0);
        targets[idx][0] = imgInfo.isMatch ? 1.0 : 0.0;
        double resultTotal = 0.0;
        double[] results = new double[identifiers.size()];
        int i = 0;
        while (i < identifiers.size()) {
            Identifier identifier = (Identifier)identifiers.get(i);
            logger.debug(IdentifyImageFitnessFunction.toCostString(identifier.cost(), identifier.getStepNum()));
            float f = identifier.identify(imgInfo.file);
            resultTotal += (double)f;
            results[i] = f;
            ++i;
        }
        logger.debug(IdentifyImageFitnessFunction.toCategorizationString(imgInfo, results));
        double[] ensembleResponse = new double[]{resultTotal / (double)identifiers.size()};
        responses[idx++][0] = ensembleResponse[0];
        logger.debug(IdentifyImageFitnessFunction.toCategorizationString(imgInfo, ensembleResponse));
        while (imgInfoIter.hasNext()) {
            imgInfo = (ImageInfo)imgInfoIter.next();
            double d = targets[idx][0] = imgInfo.isMatch ? 1.0 : 0.0;
            if (imgWidth != this.surface.getWidth() || imgHeight != this.surface.getHeight()) {
                throw new IllegalArgumentException("images must all be same dimension: " + imgWidth + ", " + imgHeight + " vs " + this.surface.getWidth() + ", " + this.surface.getHeight());
            }
            resultTotal = 0.0;
            int i2 = 0;
            while (i2 < identifiers.size()) {
                Identifier identifier = (Identifier)identifiers.get(i2);
                logger.debug(IdentifyImageFitnessFunction.toCostString(identifier.cost(), identifier.getStepNum()));
                float result3 = identifier.identify(imgInfo.file);
                resultTotal += (double)result3;
                results[i2] = result3;
                ++i2;
            }
            logger.debug(IdentifyImageFitnessFunction.toCategorizationString(imgInfo, results));
            ensembleResponse[0] = resultTotal / (double)identifiers.size();
            responses[idx++][0] = ensembleResponse[0];
            logger.debug(IdentifyImageFitnessFunction.toCategorizationString(imgInfo, ensembleResponse));
        }
        for (Identifier identifier : identifiers) {
            identifier.dispose();
        }
        ErrorRateCounter.getInstance().countErrors(targets, responses);
        double d = ErrorFunction.getInstance().calculateError(targets, responses, false);
        if (d > maxError) {
            throw new IllegalStateException("error " + d + " > max error " + maxError);
        }
        double rawFitnessValue = Math.pow(maxError - d, 2.0);
        double skewedFitness = rawFitnessValue / maxRawFitnessValue * 1000000.0;
        return (int)skewedFitness;
    }

    private static String toResultString(ImageInfo imgInfo, double affinity) {
        StringBuffer result2 = new StringBuffer();
        result2.append(imgInfo.isMatch ? (affinity > 0.5 ? "TRUE-POS" : "FALSE-NEG") : (affinity <= 0.5 ? "TRUE-NEG" : "FALSE-POS"));
        result2.append("[").append(affinity).append("]");
        return result2.toString();
    }

    private static String toCategorizationString(ImageInfo imgInfo, double[] affinities) {
        StringBuffer result2 = new StringBuffer();
        if (affinities.length > 0) {
            result2.append(IdentifyImageFitnessFunction.toResultString(imgInfo, affinities[0]));
        }
        int i = 1;
        while (i < affinities.length) {
            result2.append("/").append(IdentifyImageFitnessFunction.toResultString(imgInfo, affinities[i]));
            ++i;
        }
        result2.append(", ").append(imgInfo.file.getAbsolutePath());
        return result2.toString();
    }

    private static String toCostString(long cost, int stepCount) {
        StringBuffer result2 = new StringBuffer();
        result2.append("cost=").append(cost).append(", steps=").append(stepCount);
        return result2.toString();
    }

    @Override
    public int getMaxFitnessValue() {
        return 1000000;
    }

    @Override
    public void init(Properties props) throws Exception {
        this.transcriber = (AnjiNetTranscriber)props.singletonObjectProperty(AnjiNetTranscriber.class);
        this.randomizer = (Randomizer)props.singletonObjectProperty(Randomizer.class);
        this.identifierFactory = (AnjiNetFloatingEyeIdentifierFactory)props.singletonObjectProperty(AnjiNetFloatingEyeIdentifierFactory.class);
        this.matchDir = props.getDirProperty(IMG_MATCH_DIR_KEY);
        this.mismatchDir = props.getDirProperty(IMG_MISMATCH_DIR_KEY);
        boolean doRandomizeImgs = props.getBooleanProperty("image.randomize", false);
        if (doRandomizeImgs) {
            this.imgRandomizer = new ImageRandomizer();
            this.imgRandomizer.init(props);
            try {
                this.imgRandomizer.transformFiles(this.matchDir, this.mismatchDir);
            }
            catch (IOException e) {
                logger.error("error randomizing image files", e);
                throw new RuntimeException("error randomizing image files", e);
            }
        }
        this.loadImages();
        ErrorFunction.getInstance().init(props);
        this.surface = (Surface)props.newObjectProperty(SURFACE_CLASS_KEY);
    }

    private void loadImages() {
        this.imgInfos.clear();
        File[] matchFiles = this.matchDir.listFiles(ImageFileFilter.getInstance());
        int i = 0;
        while (i < matchFiles.length) {
            this.imgInfos.add(new ImageInfo(true, matchFiles[i]));
            ++i;
        }
        File[] mismatchFiles = this.mismatchDir.listFiles(ImageFileFilter.getInstance());
        int i2 = 0;
        while (i2 < mismatchFiles.length) {
            this.imgInfos.add(new ImageInfo(false, mismatchFiles[i2]));
            ++i2;
        }
        if (this.imgInfos.isEmpty()) {
            throw new IllegalArgumentException("must have at least one image");
        }
    }

    private class ImageInfo {
        public File file;
        public boolean isMatch;

        public ImageInfo(boolean anIsMatch, File aFile) {
            this.isMatch = anIsMatch;
            this.file = aFile;
        }
    }
}

