/*
 * Decompiled with CFR 0.152.
 */
package com.anji.imaging;

import com.anji.imaging.DefaultBufferedImageTransformer;
import com.anji.imaging.ImageFileFilter;
import com.anji.imaging.TransformParameters;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageNormalizer {
    private File origDir;
    private File resultDir;

    public ImageNormalizer(File anOrigDir, File aResultDir) {
        this.origDir = anOrigDir;
        this.resultDir = aResultDir;
    }

    public int normalize(Dimension resultDim) throws IOException {
        int result2 = 0;
        DefaultBufferedImageTransformer xformer = new DefaultBufferedImageTransformer();
        File[] files = this.origDir.listFiles(ImageFileFilter.getInstance());
        int i = 0;
        while (i < files.length) {
            File f = files[i];
            boolean isValidImgFIle = false;
            BufferedImage origImg = null;
            if (f.isFile()) {
                try {
                    origImg = ImageIO.read(f);
                    System.out.println("read " + f.getAbsolutePath());
                    isValidImgFIle = origImg != null;
                }
                catch (Throwable t) {
                    System.err.println("error reading file: " + f.getAbsolutePath() + ": " + t.toString());
                }
            }
            if (isValidImgFIle) {
                xformer.setImage(origImg);
                double scaleX = resultDim.getWidth() / (double)origImg.getWidth();
                double scaleY = resultDim.getHeight() / (double)origImg.getHeight();
                double scaleFactor = Math.max(scaleX, scaleY);
                TransformParameters parms = new TransformParameters(0, 0, 0.0, scaleFactor, scaleFactor, (int)resultDim.getWidth(), (int)resultDim.getHeight());
                Image scaledImg = xformer.transform(parms);
                BufferedImage resultImg = new BufferedImage((int)resultDim.getWidth(), (int)resultDim.getHeight(), 2);
                Graphics2D g = resultImg.createGraphics();
                g.drawImage(scaledImg, new AffineTransform(), null);
                g.dispose();
                ImageIO.write((RenderedImage)resultImg, "TIF", new File(String.valueOf(this.resultDir.getAbsolutePath()) + File.separatorChar + f.getName()));
                ++result2;
            } else {
                System.err.println("not an image file: " + f.getAbsolutePath());
            }
            ++i;
        }
        return result2;
    }
}

