/*
 * Decompiled with CFR 0.152.
 */
package com.anji.imaging;

import com.anji.imaging.ImageFileFilter;
import com.anji.util.Configurable;
import com.anji.util.Properties;
import com.anji.util.Randomizer;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class ImageRandomizer
implements Configurable {
    private static final Logger logger = Logger.getLogger(ImageRandomizer.class);
    public static final String IMG_RANDOMIZE_KEY = "image.randomize";
    private static final String IMG_MATCH_ORIG_DIR_KEY = "image.randomize.matches.originals";
    private static final String IMG_MISMATCH_ORIG_DIR_KEY = "image.randomize.mismatches.originals";
    public static final String IMG_MATCH_COUNT_KEY = "image.randomize.matches.count";
    public static final String IMG_MISMATCH_COUNT_KEY = "image.randomize.mismatches.count";
    private static final String IMG_TRANSLATEX_KEY = "image.randomize.move.x";
    private static final String IMG_TRANSLATEY_KEY = "image.randomize.move.y";
    private static final String IMG_STARTX_KEY = "image.randomize.start.x";
    private static final String IMG_STARTY_KEY = "image.randomize.start.y";
    private static final String IMG_TRANSLATEZ_KEY = "image.randomize.scale";
    private static final String IMG_TRANSFORMTHETA_KEY = "image.randomize.rotate";
    private static final String IMG_CROPSIZE_KEY = "image.randomize.crop.size";
    private static final String IMG_SHEARX_KEY = "image.randomize.shear.x";
    private static final String IMG_SHEARY_KEY = "image.randomize.shear.y";
    private static final String IMG_BRIGHTNESS_KEY = "image.randomize.brightness";
    private static final String IMG_TOGGLE_KEY = "image.randomize.toggle";
    private double maxShearX;
    private double maxShearY;
    private int maxTranslateX;
    private int maxTranslateY;
    private double maxAdjustSaturation;
    private double toggleRatio;
    private int startX;
    private int startY;
    private double maxScale;
    private double maxRotate;
    private int cropSize;
    private List origMatchImgs;
    private List origMismatchImgs;
    private int matchImageCount;
    private int mismatchImageCount;
    private Randomizer randomizer;

    @Override
    public void init(Properties props) throws IOException {
        this.randomizer = (Randomizer)props.singletonObjectProperty(Randomizer.class);
        this.maxTranslateX = props.getIntProperty(IMG_TRANSLATEX_KEY, 0);
        this.maxTranslateY = props.getIntProperty(IMG_TRANSLATEY_KEY, 0);
        this.startX = props.getIntProperty(IMG_STARTX_KEY, -1);
        this.startY = props.getIntProperty(IMG_STARTY_KEY, -1);
        this.maxScale = props.getDoubleProperty(IMG_TRANSLATEZ_KEY, 0.0);
        this.maxRotate = props.getIntProperty(IMG_TRANSFORMTHETA_KEY, 0);
        this.maxShearX = props.getDoubleProperty(IMG_SHEARX_KEY, 0.0);
        this.maxShearY = props.getDoubleProperty(IMG_SHEARY_KEY, 0.0);
        this.maxAdjustSaturation = props.getDoubleProperty(IMG_BRIGHTNESS_KEY, 0.0);
        this.toggleRatio = props.getDoubleProperty(IMG_TOGGLE_KEY, 0.0);
        this.cropSize = props.getIntProperty(IMG_CROPSIZE_KEY);
        this.matchImageCount = props.getIntProperty(IMG_MATCH_COUNT_KEY);
        this.mismatchImageCount = props.getIntProperty(IMG_MISMATCH_COUNT_KEY);
        this.origMatchImgs = ImageRandomizer.readImages(props.getDirProperty(IMG_MATCH_ORIG_DIR_KEY));
        this.origMismatchImgs = ImageRandomizer.readImages(props.getDirProperty(IMG_MISMATCH_ORIG_DIR_KEY));
        if (this.origMatchImgs.size() + this.origMismatchImgs.size() <= 0) {
            throw new IllegalArgumentException("no images loaded");
        }
    }

    private static List readImages(File dir) throws IOException {
        ArrayList<BufferedImage> result2 = new ArrayList<BufferedImage>();
        File[] files = dir.listFiles(ImageFileFilter.getInstance());
        int i = 0;
        while (i < files.length) {
            File f = files[i];
            if (f.isFile()) {
                BufferedImage img = ImageIO.read(f);
                if (img == null) {
                    logger.info(String.valueOf(f.getAbsolutePath()) + " is not an image file");
                } else {
                    result2.add(img);
                }
            } else {
                logger.info(String.valueOf(f.getAbsolutePath()) + " is not a proper file");
            }
            ++i;
        }
        logger.info(String.valueOf(result2.size()) + " images loaded from " + dir.getAbsolutePath());
        return result2;
    }

    private double nextDoubleWithinRange(double range) {
        return range * (this.randomizer.getRand().nextDouble() * 2.0 - 1.0);
    }

    private static BufferedImage transformShear(BufferedImage image, double shearXFactor, double shearYFactor) {
        double origCenterX = image.getWidth() / 2;
        double origCenterY = image.getHeight() / 2;
        AffineTransform at = new AffineTransform();
        double newCenterX = origCenterX + shearXFactor * origCenterY;
        double newCenterY = origCenterY + shearYFactor * origCenterX;
        at.shear(shearXFactor, shearYFactor);
        at.translate(origCenterX - newCenterX, origCenterY - newCenterY);
        AffineTransformOp op = new AffineTransformOp(at, 2);
        return op.filter(image, null).getSubimage(0, 0, image.getWidth(), image.getHeight());
    }

    private static int boundByteRange(int x) {
        return Math.max(Math.min(x, 255), 0);
    }

    private static BufferedImage transformSaturation(BufferedImage image, int delta, Random rand, double toggleRatio) {
        BufferedImage result2 = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        int x = 0;
        while (x < result2.getWidth()) {
            int y = 0;
            while (y < result2.getHeight()) {
                int origRgb = rand.nextDouble() < toggleRatio ? rand.nextInt() : image.getRGB(x, y);
                int origSaturation = (origRgb & 0xFF000000) >>> 24;
                int origR = (origRgb & 0xFF0000) >>> 16;
                int origG = (origRgb & 0xFF00) >>> 8;
                int origB = origRgb & 0xFF;
                int newSaturation = ImageRandomizer.boundByteRange(origSaturation + delta);
                int newR = ImageRandomizer.boundByteRange(origR + delta);
                int newG = ImageRandomizer.boundByteRange(origG + delta);
                int newB = ImageRandomizer.boundByteRange(origB + delta);
                int newRgb = (newSaturation << 24) + (newR << 16) + (newG << 8) + newB;
                result2.setRGB(x, y, newRgb);
                ++y;
            }
            ++x;
        }
        return result2;
    }

    private static BufferedImage transformRotate(BufferedImage image, double rotate) {
        AffineTransform at = new AffineTransform();
        at.rotate(Math.toRadians(rotate), image.getWidth() / 2, image.getHeight() / 2);
        AffineTransformOp op = new AffineTransformOp(at, 2);
        BufferedImage postRotate = op.filter(image, null);
        return postRotate.getSubimage(0, 0, image.getWidth(), image.getHeight());
    }

    private static BufferedImage transformScale(BufferedImage image, double scaleFactor) {
        AffineTransform at = new AffineTransform();
        at.scale(scaleFactor, scaleFactor);
        AffineTransformOp op = new AffineTransformOp(at, 2);
        return op.filter(image, null);
    }

    private BufferedImage transform(BufferedImage image) {
        int yCropSize;
        int xCropSize;
        int saturationDelta = (int)(this.nextDoubleWithinRange(this.maxAdjustSaturation) * 255.0);
        BufferedImage postAdjustSaturation = ImageRandomizer.transformSaturation(image, saturationDelta, this.randomizer.getRand(), this.toggleRatio);
        double shearXFactor = this.nextDoubleWithinRange(this.maxShearX);
        double shearYFactor = this.nextDoubleWithinRange(this.maxShearY);
        BufferedImage postShear = ImageRandomizer.transformShear(postAdjustSaturation, shearXFactor, shearYFactor);
        double rotate = this.nextDoubleWithinRange(this.maxRotate);
        BufferedImage postRotate = ImageRandomizer.transformRotate(postShear, rotate);
        double scaleFactor = 1.0 + this.nextDoubleWithinRange(this.maxScale);
        BufferedImage postScale = ImageRandomizer.transformScale(postRotate, scaleFactor);
        double deltaX = this.nextDoubleWithinRange(this.maxTranslateX);
        int xCropStartPoint = this.startX > -1 ? this.startX : (postScale.getWidth() - this.cropSize) / 2;
        xCropStartPoint = (int)((double)xCropStartPoint - deltaX);
        xCropStartPoint = Math.max(xCropStartPoint, 0);
        double deltaY = this.nextDoubleWithinRange(this.maxTranslateY);
        int yCropStartPoint = this.startY > -1 ? this.startY : (postScale.getHeight() - this.cropSize) / 2;
        yCropStartPoint = (int)((double)yCropStartPoint - deltaY);
        BufferedImage postCrop = postScale.getSubimage(xCropStartPoint, yCropStartPoint = Math.max(yCropStartPoint, 0), xCropSize = Math.min(this.cropSize, postScale.getWidth() - xCropStartPoint), yCropSize = Math.min(this.cropSize, postScale.getHeight() - yCropStartPoint));
        if (postCrop.getWidth() != this.cropSize || postCrop.getHeight() != this.cropSize) {
            double xScaleFactor = (double)this.cropSize / (double)postCrop.getWidth();
            double yScaleFactor = (double)this.cropSize / (double)postCrop.getHeight();
            double rescaleFactor = Math.max(xScaleFactor, yScaleFactor);
            AffineTransform at = new AffineTransform();
            at.scale(rescaleFactor, rescaleFactor);
            AffineTransformOp op = new AffineTransformOp(at, 1);
            postCrop = op.filter(postCrop, null);
            postCrop = postCrop.getSubimage(0, 0, this.cropSize, this.cropSize);
        }
        return postCrop;
    }

    private void clear(File dir) {
        if (dir.isDirectory()) {
            File[] files = dir.listFiles(ImageFileFilter.getInstance());
            int i = 0;
            while (i < files.length) {
                files[i].delete();
                ++i;
            }
        } else {
            throw new IllegalArgumentException(String.valueOf(dir.getAbsolutePath()) + " is not a directory");
        }
    }

    public void transformFiles(File destMatchDIr, File destMismatchDir) throws IOException {
        File outFile;
        BufferedImage origImg;
        int idx;
        this.clear(destMatchDIr);
        this.clear(destMismatchDir);
        int i = 0;
        while (i < this.matchImageCount) {
            idx = this.randomizer.getRand().nextInt(this.origMatchImgs.size());
            origImg = (BufferedImage)this.origMatchImgs.get(idx);
            outFile = new File(destMatchDIr, "img" + i + ".tif");
            ImageIO.write((RenderedImage)this.transform(origImg), "tif", outFile);
            ++i;
        }
        i = 0;
        while (i < this.mismatchImageCount) {
            idx = this.randomizer.getRand().nextInt(this.origMismatchImgs.size());
            origImg = (BufferedImage)this.origMismatchImgs.get(idx);
            outFile = new File(destMismatchDir, "img" + i + ".tif");
            ImageIO.write((RenderedImage)this.transform(origImg), "tif", outFile);
            ++i;
        }
    }
}

