/*
 * Decompiled with CFR 0.152.
 */
package com.anji.imaging;

import com.anji.imaging.MagickImageTransformer;
import com.anji.imaging.Surface;
import com.anji.imaging.TransformParameters;
import com.anji.util.Properties;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import magick.ImageInfo;
import magick.MagickException;
import magick.MagickImage;
import org.apache.log4j.Logger;

public class JMagickSurface
implements Surface {
    private static final Logger logger = Logger.getLogger(JMagickSurface.class);
    private MagickImage data;
    private Dimension surfaceDimension;
    private int[] pixels;
    private MagickImageTransformer xformer = new MagickImageTransformer();
    private static final String PIXEL_MAP = "I";

    @Override
    public synchronized void setImage(File aFile) throws IOException {
        String fullPath = aFile.getAbsolutePath();
        try {
            ImageInfo info = new ImageInfo(fullPath);
            this.data = new MagickImage(info);
            String sizeStr = info.getSize();
            int xIdx = sizeStr.indexOf(120);
            String widthStr = sizeStr.substring(0, xIdx);
            String heightStr = sizeStr.substring(xIdx + 1);
            int width = Integer.parseInt(widthStr);
            int height = Integer.parseInt(heightStr);
            if (this.surfaceDimension == null) {
                this.surfaceDimension = new Dimension(width, height);
            } else if ((double)width != this.surfaceDimension.getWidth() || (double)height != this.surfaceDimension.getHeight()) {
                throw new IllegalArgumentException("JMagickSurface resize not yet implemented");
            }
            this.pixels = null;
            this.xformer.setImage(this.data);
        }
        catch (MagickException e) {
            String msg = "error creating MagickImage from file " + fullPath;
            logger.error(msg);
            throw new IOException(msg);
        }
    }

    @Override
    public synchronized int[] transform(TransformParameters parms) {
        int width = parms.getCropWidth();
        int height = parms.getCropHeight();
        int[] result2 = new int[width * height];
        try {
            this.xformer.transform(parms).dispatchImage(0, 0, width, height, PIXEL_MAP, result2);
        }
        catch (MagickException e) {
            String msg = "error transforming image";
            logger.error(msg, e);
            throw new IllegalStateException(String.valueOf(msg) + ": " + e);
        }
        return result2;
    }

    @Override
    public synchronized int[] getData() {
        if (this.pixels == null) {
            try {
                Dimension dim = this.data.getDimension();
                this.data.dispatchImage(0, 0, dim.width, dim.height, PIXEL_MAP, this.pixels);
            }
            catch (MagickException e) {
                String msg = "error dispatching pixels";
                logger.error(msg, e);
                throw new IllegalStateException(String.valueOf(msg) + ": " + e);
            }
        }
        return this.pixels;
    }

    @Override
    public synchronized int getWidth() {
        try {
            return this.data.getDimension().width;
        }
        catch (MagickException e) {
            String msg = "error getting image width";
            logger.error(msg, e);
            throw new IllegalStateException(String.valueOf(msg) + ": " + e);
        }
    }

    @Override
    public synchronized int getHeight() {
        try {
            return this.data.getDimension().height;
        }
        catch (MagickException e) {
            String msg = "error getting image height";
            logger.error(msg, e);
            throw new IllegalStateException(String.valueOf(msg) + ": " + e);
        }
    }

    @Override
    public synchronized int getValue(int x, int y) {
        return this.getData()[x + y * this.getWidth()];
    }

    @Override
    public synchronized void init(Properties props) throws Exception {
        try {
            this.surfaceDimension = new Dimension(props.getIntProperty("surface.width"), props.getIntProperty("surface.height"));
        }
        catch (RuntimeException e) {
            logger.warn("surface dimensions not set, defaulting to size of first image");
        }
        this.xformer = (MagickImageTransformer)props.newObjectProperty("surface.transformer");
    }
}

