/*
 * Decompiled with CFR 0.152.
 */
package com.anji.imaging;

import com.anji.imaging.BufferedImageTransformer;
import com.anji.imaging.DefaultBufferedImageTransformer;
import com.anji.imaging.Surface;
import com.anji.imaging.TransformParameters;
import com.anji.util.Configurable;
import com.anji.util.Properties;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class Java2DSurface
implements Surface,
Configurable {
    private static final Logger logger = Logger.getLogger(Java2DSurface.class);
    private static final int IMAGE_TYPE = 2;
    private BufferedImage data;
    private BufferedImage dataPlusGutter;
    private int[] pixels;
    private BufferedImageTransformer xformer = new DefaultBufferedImageTransformer();
    private Dimension surfaceDimension;

    @Override
    public synchronized void setImage(File imageFile) throws IOException {
        BufferedImage img = ImageIO.read(imageFile);
        if (img == null) {
            throw new IllegalArgumentException("invalid image file: " + imageFile.getAbsolutePath());
        }
        this.setImage(img);
    }

    public synchronized void setImage(BufferedImage newData) {
        int width = newData.getWidth();
        int height = newData.getHeight();
        Image scaledData = newData;
        if (this.surfaceDimension == null) {
            this.surfaceDimension = new Dimension(width, height);
        } else if ((double)width != this.surfaceDimension.getWidth() || (double)height != this.surfaceDimension.getHeight()) {
            width = (int)this.surfaceDimension.getWidth();
            height = (int)this.surfaceDimension.getHeight();
            scaledData = newData.getScaledInstance(width, height, 16);
        }
        this.data = new BufferedImage(width, height, 2);
        Graphics2D g = this.data.createGraphics();
        g.drawImage(scaledData, 0, 0, null);
        g.dispose();
        int offset = Math.max((int)(this.surfaceDimension.getWidth() * 0.75 + 0.5), (int)(this.surfaceDimension.getHeight() * 0.75 + 0.5));
        this.dataPlusGutter = new BufferedImage(width + offset * 2, height + offset * 2, 2);
        g = this.dataPlusGutter.createGraphics();
        g.drawImage(newData, null, offset, offset);
        g.dispose();
        this.pixels = null;
        this.xformer.setImage(this.dataPlusGutter);
    }

    @Override
    public synchronized int getWidth() {
        return this.data.getWidth();
    }

    @Override
    public synchronized int getHeight() {
        return this.data.getHeight();
    }

    @Override
    public synchronized int getValue(int x, int y) {
        return this.data.getRGB(x, y);
    }

    public synchronized String toXml() {
        StringBuffer result2 = new StringBuffer();
        result2.append("<surface>\n");
        int x = 0;
        while (x < this.getWidth()) {
            result2.append("\t");
            int y = 0;
            while (y < this.getHeight()) {
                result2.append("<space x=\"").append(x);
                result2.append("\" y=\"").append(y);
                result2.append("\" value=\"").append(this.getValue(x, y)).append("\" />");
                ++y;
            }
            result2.append("\n");
            ++x;
        }
        result2.append("</surface>\n");
        return result2.toString();
    }

    public String toString() {
        if (this.data == null || this.dataPlusGutter == null) {
            return "uninitialized";
        }
        return "surface/fullcanvas=" + this.data.getWidth() + "," + this.data.getHeight() + "/" + this.dataPlusGutter.getWidth() + "," + this.dataPlusGutter.getHeight();
    }

    @Override
    public synchronized int[] getData() {
        if (this.pixels == null) {
            this.pixels = Java2DSurface.grabPixels(this.data, 0, 0, this.data.getWidth(), this.data.getHeight());
        }
        return this.pixels;
    }

    public synchronized BufferedImage getBufferedImage() {
        return this.data;
    }

    private static int[] grabPixels(Image img, int startX, int startY, int width, int height) {
        PixelGrabber grabber = new PixelGrabber(img, startX, startY, width, height, false);
        try {
            if (!grabber.grabPixels()) {
                throw new IllegalStateException("error grabbing pixels");
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("error grabbing pixels: " + e);
        }
        return (int[])grabber.getPixels();
    }

    @Override
    public synchronized int[] transform(TransformParameters parms) {
        return Java2DSurface.grabPixels(this.xformer.transform(parms), 0, 0, parms.getCropWidth(), parms.getCropHeight());
    }

    @Override
    public synchronized void init(Properties props) throws Exception {
        try {
            this.surfaceDimension = new Dimension(props.getIntProperty("surface.width"), props.getIntProperty("surface.height"));
        }
        catch (RuntimeException e) {
            logger.warn("surface dimensions not set, defaulting to size of first image");
        }
        this.xformer = (BufferedImageTransformer)props.newObjectProperty("surface.transformer");
    }
}

