/*
 * Decompiled with CFR 0.152.
 */
package com.anji.imaging;

import com.anji.imaging.TransformParameters;
import java.awt.Dimension;
import java.awt.Rectangle;
import magick.ImageInfo;
import magick.MagickException;
import magick.MagickImage;
import org.apache.log4j.Logger;

public class MagickImageTransformer {
    private static final Logger logger = Logger.getLogger(MagickImageTransformer.class);
    private MagickImage data;

    public void setImage(MagickImage anImg) {
        this.data = anImg;
    }

    public MagickImage transform(TransformParameters parms) {
        try {
            double rotate;
            MagickImage result2 = this.data.rollImage(parms.getTranslateX(), parms.getTranslateY());
            result2.setFileName("c:/temp/test/1-translate.tif");
            result2.writeImage(new ImageInfo("c:/temp/test/1-translate.tif"));
            double scaleX = parms.getScaleX();
            double scaleY = parms.getScaleY();
            if (scaleX != 1.0 || scaleY != 1.0) {
                Dimension d = result2.getDimension();
                int newCols = (int)(d.getWidth() * scaleX + 0.5);
                int newRows = (int)(d.getHeight() * scaleY + 0.5);
                result2 = result2.scaleImage(newCols, newRows);
                result2.setFileName("c:/temp/test/2-scale.tif");
                result2.writeImage(new ImageInfo("c:/temp/test/2-scale.tif"));
            }
            if ((rotate = parms.getRotate() * 360.0 / Math.PI) != 0.0) {
                result2 = result2.rotateImage(rotate);
                result2.setFileName("c:/temp/test/3-rotate.tif");
                result2.writeImage(new ImageInfo("c:/temp/test/3-rotate.tif"));
            }
            if (parms.isFlipHorizontal()) {
                result2 = result2.flopImage();
                result2.setFileName("c:/temp/test/4-flip.tif");
                result2.writeImage(new ImageInfo("c:/temp/test/4-flip.tif"));
            }
            int cropX = parms.getCropWidth();
            int cropY = parms.getCropHeight();
            Dimension d = result2.getDimension();
            if (cropX != d.width || cropY != d.height) {
                int startX = (int)(((double)(d.width - cropX) + 1.0) / 2.0);
                int startY = (int)(((double)(d.height - cropY) + 1.0) / 2.0);
                result2 = result2.chopImage(new Rectangle(startX, startY, cropX, cropY));
                result2.setFileName("c:/temp/test/5-crop.tif");
                result2.writeImage(new ImageInfo("c:/temp/test/5-crop.tif"));
            }
            return result2;
        }
        catch (MagickException e) {
            String msg = "error transforming MagickImage";
            logger.error(msg, e);
            throw new IllegalStateException(String.valueOf(msg) + ": " + e);
        }
    }
}

