/*
 * Decompiled with CFR 0.152.
 */
package com.anji.imaging;

import com.anji.imaging.RangeTranslator;

public class RangeTranslatorFactory {
    private RangeTranslator nullTranslator = new NullRangeTranslator();
    private static RangeTranslatorFactory instance = null;

    private RangeTranslatorFactory() {
    }

    public static RangeTranslatorFactory getInstance() {
        if (instance == null) {
            instance = new RangeTranslatorFactory();
        }
        return instance;
    }

    public RangeTranslator getTranslator(double aSrcMin, double aSrcMax, double aDestMin, double aDestMax) {
        return aSrcMin == aDestMin && aSrcMax == aDestMax ? this.nullTranslator : new DefaultRangeTranslator(aSrcMin, aSrcMax, aDestMin, aDestMax);
    }

    private class DefaultRangeTranslator
    implements RangeTranslator {
        private double srcMin;
        private double destMin;
        private double factor;

        public DefaultRangeTranslator(double aSrcMin, double aSrcMax, double aDestMin, double aDestMax) {
            if (aSrcMax < aSrcMin || aDestMax < aDestMin) {
                throw new IllegalArgumentException("min < max");
            }
            this.srcMin = aSrcMin;
            this.destMin = aDestMin;
            this.factor = (aDestMax - aDestMin) / (aSrcMax - aSrcMin);
        }

        @Override
        public double translate(double value) {
            return (value - this.srcMin) * this.factor + this.destMin;
        }
    }

    private class NullRangeTranslator
    implements RangeTranslator {
        private NullRangeTranslator() {
        }

        @Override
        public double translate(double value) {
            return value;
        }
    }
}

