/*
 * Decompiled with CFR 0.152.
 */
package com.anji.imaging;

public class TransformParameters {
    private int translateX;
    private int translateY;
    private double rotate;
    private double scaleX;
    private double scaleY;
    private int cropWidth;
    private int cropHeight;
    private boolean flipHorizontal;

    public TransformParameters(int aTranslateX, int aTranslateY, double aRotate, double aScaleX, double aScaleY, int aCropX, int aCropY) {
        this(aTranslateX, aTranslateY, aRotate, aScaleX, aScaleY, aCropX, aCropY, false);
    }

    public static final TransformParameters newTranslateParameters(int aTranslateX, int aTranslateY, int aCropX, int aCropY) {
        return new TransformParameters(aTranslateX, aTranslateY, 0.0, 1.0, 1.0, aCropX, aCropY);
    }

    public static final TransformParameters newRotateParameters(double aRotate, int aCropX, int aCropY) {
        return new TransformParameters(0, 0, aRotate, 1.0, 1.0, aCropX, aCropY);
    }

    public static final TransformParameters newScaleParameters(double aScaleX, double aScaleY, int aCropX, int aCropY) {
        return new TransformParameters(0, 0, 0.0, aScaleX, aScaleY, aCropX, aCropY);
    }

    public TransformParameters(int aTranslateX, int aTranslateY, double aRotate, double aScaleX, double aScaleY, int aCropX, int aCropY, boolean aFlipHorizontal) {
        this.translateX = aTranslateX;
        this.translateY = aTranslateY;
        this.rotate = aRotate;
        this.scaleX = aScaleX;
        this.scaleY = aScaleY;
        this.cropWidth = aCropX;
        this.cropHeight = aCropY;
        this.flipHorizontal = aFlipHorizontal;
    }

    public int getCropWidth() {
        return this.cropWidth;
    }

    public int getCropHeight() {
        return this.cropHeight;
    }

    public double getRotate() {
        return this.rotate;
    }

    public double getScaleX() {
        return this.scaleX;
    }

    public double getScaleY() {
        return this.scaleY;
    }

    public int getTranslateX() {
        return this.translateX;
    }

    public int getTranslateY() {
        return this.translateY;
    }

    public boolean isFlipHorizontal() {
        return this.flipHorizontal;
    }

    public String toString() {
        StringBuffer result2 = new StringBuffer();
        result2.append("move/scal/turn/flip/crop=");
        result2.append(this.translateX).append(",").append(this.translateY).append("/");
        double displayScaleX = (double)((int)(this.scaleX * 100000.0)) / 100000.0;
        double displayScaleY = (double)((int)(this.scaleY * 100000.0)) / 100000.0;
        result2.append(displayScaleX).append(",").append(displayScaleY).append("/");
        double displayRotate = (double)((int)(this.rotate * 100000.0)) / 100000.0;
        result2.append(displayRotate).append("/");
        result2.append(this.flipHorizontal).append("/");
        result2.append(this.cropHeight).append(",").append(this.cropWidth);
        return result2.toString();
    }
}

