/*
 * Decompiled with CFR 0.152.
 */
package com.anji.integration;

import com.anji.integration.Activator;
import com.anji.integration.AnjiActivator;
import com.anji.integration.AnjiNetTranscriber;
import com.anji.integration.Transcriber;
import com.anji.integration.TranscriberException;
import com.anji.util.Configurable;
import com.anji.util.Properties;
import org.jgap.Chromosome;

public class ActivatorTranscriber
implements Configurable,
Transcriber {
    public static final String TYPE_KEY = "ann.type";
    public static final String RECURRENT_CYCLES_KEY = "recurrent.cycles";
    public static final String ANJI_TYPE = "anji";
    public static final String JOONE_TYPE = "joone";
    private String type = "anji";
    private int recurrentCycles;
    private AnjiNetTranscriber transcriber;

    @Override
    public void init(Properties props) {
        this.type = props.getProperty(TYPE_KEY, ANJI_TYPE);
        this.recurrentCycles = props.getIntProperty(RECURRENT_CYCLES_KEY, 1);
        this.transcriber = (AnjiNetTranscriber)props.singletonObjectProperty(AnjiNetTranscriber.class);
    }

    public Activator newActivator(Chromosome ch) throws TranscriberException {
        AnjiActivator result2 = null;
        if (!ANJI_TYPE.equals(this.type)) {
            if (JOONE_TYPE.equals(this.type)) {
                throw new TranscriberException("JOONE not implemented");
            }
            throw new IllegalStateException("invalid type: " + this.type);
        }
        result2 = new AnjiActivator(this.transcriber.newAnjiNet(ch), this.recurrentCycles);
        return result2;
    }

    @Override
    public Class getPhenotypeClass() {
        return Activator.class;
    }

    @Override
    public Object transcribe(Chromosome c2) throws TranscriberException {
        return this.newActivator(c2);
    }
}

