/*
 * Decompiled with CFR 0.152.
 */
package com.anji.integration;

import com.anji.integration.Activator;
import com.anji.nn.AnjiNet;
import com.anji.nn.Neuron;
import com.anji.nn.Pattern;

public class AnjiActivator
implements Activator {
    private AnjiNet net;
    private Pattern inputPattern = null;
    private int numCycles = 1;
    private int outputDimension;
    private double minResponseValue;
    private double maxResponseValue;

    public AnjiActivator(AnjiNet aNet, int aNumCycles) throws IllegalArgumentException {
        this.setNumCycles(aNumCycles);
        this.net = aNet;
        this.outputDimension = aNet.getOutputDimension();
        this.inputPattern = new Pattern(aNet.getInputDimension());
        int i = 0;
        while (i < aNet.getInputDimension()) {
            Neuron n = aNet.getInputNeuron(i);
            n.addIncomingConnection(this.inputPattern.getConnection(i));
            ++i;
        }
        this.minResponseValue = this.net.getOutputNeuron(0).getFunc().getMinValue();
        this.maxResponseValue = this.net.getOutputNeuron(0).getFunc().getMaxValue();
        i = 1;
        while (i < this.net.getOutputDimension()) {
            if (this.minResponseValue != this.net.getOutputNeuron(i).getFunc().getMinValue() || this.maxResponseValue != this.net.getOutputNeuron(i).getFunc().getMaxValue()) {
                throw new IllegalArgumentException("min and max values for response nodes differ");
            }
            ++i;
        }
    }

    @Override
    public double[] next() {
        return this.next((double[])null);
    }

    @Override
    public double[] next(double[] newInputValues) {
        if (newInputValues != null) {
            this.inputPattern.setValues(newInputValues);
        }
        int cycle = 0;
        while (cycle < this.numCycles - 1) {
            this.net.step();
            this.net.fullyActivate();
            ++cycle;
        }
        this.net.step();
        double[] result2 = new double[this.outputDimension];
        int idx = 0;
        while (idx < this.outputDimension) {
            Neuron n = this.net.getOutputNeuron(idx);
            result2[idx] = n.getValue();
            ++idx;
        }
        this.net.fullyActivate();
        return result2;
    }

    @Override
    public double[][] next(double[][] newInputValues) {
        double[][] result2 = new double[newInputValues.length][];
        int i = 0;
        while (i < newInputValues.length) {
            result2[i] = this.next(newInputValues[i]);
            ++i;
        }
        return result2;
    }

    public void setInputPattern(Pattern array) {
        this.inputPattern = array;
    }

    @Override
    public void reset() {
        this.net.reset();
    }

    public String toString() {
        return this.net.toString();
    }

    @Override
    public String toXml() {
        return this.net.toXml();
    }

    @Override
    public String getName() {
        return this.net.getName();
    }

    public void setNumCycles(int aNumCycles) throws IllegalArgumentException {
        if (aNumCycles < 1) {
            throw new IllegalArgumentException("numCycles must be >= 1");
        }
        this.numCycles = aNumCycles;
    }

    @Override
    public int getInputDimension() {
        return this.inputPattern.getDimension();
    }

    @Override
    public int getOutputDimension() {
        return this.outputDimension;
    }

    public boolean isRecurrent() {
        return this.net.isRecurrent();
    }

    @Override
    public double getMinResponse() {
        return this.net.getOutputNeuron(0).getFunc().getMinValue();
    }

    @Override
    public double getMaxResponse() {
        return this.net.getOutputNeuron(0).getFunc().getMaxValue();
    }

    @Override
    public String getXmlRootTag() {
        return "network";
    }

    @Override
    public String getXmld() {
        return this.net.getName();
    }
}

