/*
 * Decompiled with CFR 0.152.
 */
package com.anji.integration;

import com.anji.integration.Transcriber;
import com.anji.integration.TranscriberException;
import com.anji.neat.ConnectionAllele;
import com.anji.neat.NeatChromosomeUtility;
import com.anji.neat.NeuronAllele;
import com.anji.neat.NeuronType;
import com.anji.nn.ActivationFunctionFactory;
import com.anji.nn.AnjiNet;
import com.anji.nn.CacheNeuronConnection;
import com.anji.nn.Neuron;
import com.anji.nn.NeuronConnection;
import com.anji.nn.RecurrencyPolicy;
import com.anji.util.Configurable;
import com.anji.util.Properties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.SortedMap;
import org.apache.log4j.Logger;
import org.jgap.Chromosome;

public class AnjiNetTranscriber
implements Transcriber,
Configurable {
    private static final Logger logger = Logger.getLogger(AnjiNetTranscriber.class);
    private RecurrencyPolicy recurrencyPolicy = RecurrencyPolicy.BEST_GUESS;

    public AnjiNetTranscriber() {
        this(RecurrencyPolicy.BEST_GUESS);
    }

    public AnjiNetTranscriber(RecurrencyPolicy aPolicy) {
        this.recurrencyPolicy = aPolicy;
    }

    @Override
    public void init(Properties props) {
        this.recurrencyPolicy = RecurrencyPolicy.load(props);
    }

    @Override
    public Object transcribe(Chromosome genotype) throws TranscriberException {
        return this.newAnjiNet(genotype);
    }

    public AnjiNet newAnjiNet(Chromosome genotype) throws TranscriberException {
        HashMap<Long, Neuron> allNeurons = new HashMap<Long, Neuron>();
        SortedMap inNeuronAlleles = NeatChromosomeUtility.getNeuronMap(genotype.getAlleles(), NeuronType.INPUT);
        ArrayList<Neuron> inNeurons = new ArrayList<Neuron>();
        for (NeuronAllele neuronAllele : inNeuronAlleles.values()) {
            Neuron n = new Neuron(ActivationFunctionFactory.getInstance().get(neuronAllele.getActivationType().toString()));
            n.setId(neuronAllele.getInnovationId());
            inNeurons.add(n);
            allNeurons.put(neuronAllele.getInnovationId(), n);
        }
        SortedMap outNeuronAlleles = NeatChromosomeUtility.getNeuronMap(genotype.getAlleles(), NeuronType.OUTPUT);
        ArrayList<Neuron> outNeurons = new ArrayList<Neuron>();
        for (NeuronAllele neuronAllele : outNeuronAlleles.values()) {
            Neuron n = new Neuron(ActivationFunctionFactory.getInstance().get(neuronAllele.getActivationType().toString()));
            n.setId(neuronAllele.getInnovationId());
            outNeurons.add(n);
            allNeurons.put(neuronAllele.getInnovationId(), n);
        }
        SortedMap hiddenNeuronAlleles = NeatChromosomeUtility.getNeuronMap(genotype.getAlleles(), NeuronType.HIDDEN);
        for (NeuronAllele neuronAllele : hiddenNeuronAlleles.values()) {
            Neuron n = new Neuron(ActivationFunctionFactory.getInstance().get(neuronAllele.getActivationType().toString()));
            n.setId(neuronAllele.getInnovationId());
            allNeurons.put(neuronAllele.getInnovationId(), n);
        }
        ArrayList<NeuronConnection> recurrentConns = new ArrayList<NeuronConnection>();
        List remainingConnAlleles = NeatChromosomeUtility.getConnectionList(genotype.getAlleles());
        HashSet currentNeuronInnovationIds = new HashSet(outNeuronAlleles.keySet());
        HashSet traversedNeuronInnovationIds = new HashSet(currentNeuronInnovationIds);
        HashSet<Long> nextNeuronInnovationIds = new HashSet<Long>();
        while (!remainingConnAlleles.isEmpty() && !currentNeuronInnovationIds.isEmpty()) {
            nextNeuronInnovationIds.clear();
            Collection connAlleles = NeatChromosomeUtility.extractConnectionAllelesForDestNeurons(remainingConnAlleles, currentNeuronInnovationIds);
            for (ConnectionAllele connAllele : connAlleles) {
                Neuron src = (Neuron)allNeurons.get(connAllele.getSrcNeuronId());
                Neuron dest = (Neuron)allNeurons.get(connAllele.getDestNeuronId());
                if (src != null) {
                    // empty if block
                }
                boolean cached = false;
                if (RecurrencyPolicy.LAZY.equals(this.recurrencyPolicy)) {
                    cached = true;
                } else if (RecurrencyPolicy.BEST_GUESS.equals(this.recurrencyPolicy)) {
                    boolean maybeRecurrent = traversedNeuronInnovationIds.contains(connAllele.getSrcNeuronId());
                    cached = maybeRecurrent || this.recurrencyPolicy.equals(RecurrencyPolicy.LAZY);
                }
                NeuronConnection conn = null;
                if (cached) {
                    conn = new CacheNeuronConnection(src, connAllele.getWeight());
                    recurrentConns.add(conn);
                } else {
                    conn = new NeuronConnection(src, connAllele.getWeight());
                }
                conn.setId(connAllele.getInnovationId());
                dest.addIncomingConnection(conn);
                nextNeuronInnovationIds.add(connAllele.getSrcNeuronId());
            }
            traversedNeuronInnovationIds.addAll(nextNeuronInnovationIds);
            currentNeuronInnovationIds.clear();
            currentNeuronInnovationIds.addAll(nextNeuronInnovationIds);
            remainingConnAlleles.removeAll(connAlleles);
        }
        if (!remainingConnAlleles.isEmpty()) {
            logger.warn("not all connection genes handled: " + genotype.toString());
        }
        traversedNeuronInnovationIds.addAll(inNeuronAlleles.keySet());
        if (traversedNeuronInnovationIds.size() != allNeurons.size()) {
            logger.warn("did not traverse all neurons: " + genotype.toString());
        }
        return new AnjiNet(allNeurons.values(), inNeurons, outNeurons, recurrentConns, genotype.getId().toString());
    }

    @Override
    public Class getPhenotypeClass() {
        return AnjiNet.class;
    }
}

