/*
 * Decompiled with CFR 0.152.
 */
package com.anji.integration;

import com.anji.integration.AnjiActivator;
import com.anji.integration.AnjiNetTranscriber;
import com.anji.persistence.FilePersistence;
import com.anji.util.Configurable;
import com.anji.util.DummyConfiguration;
import com.anji.util.Properties;
import org.apache.log4j.Logger;
import org.jgap.Chromosome;

public class ChromosomeToNetworkXml
implements Configurable {
    private static Logger logger = Logger.getLogger(ChromosomeToNetworkXml.class);
    private FilePersistence db = new FilePersistence();
    private AnjiNetTranscriber transcriber;

    @Override
    public void init(Properties props) {
        try {
            this.db.init(props);
            this.transcriber = (AnjiNetTranscriber)props.singletonObjectProperty(AnjiNetTranscriber.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid properties: " + e.getClass() + ": " + e.getMessage());
        }
    }

    public String toNetworkXml(String chromId) throws Exception {
        Chromosome chrom = this.db.loadChromosome(chromId, new DummyConfiguration());
        AnjiActivator activator = new AnjiActivator(this.transcriber.newAnjiNet(chrom), 1);
        String result2 = activator.toXml();
        this.db.store(activator);
        return result2;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("ANJI v2.0, Copyright (C) 2004 Derek James and Philip Tucker\nANJI comes with ABSOLUTELY NO WARRANTY\nThis is free software, and you are welcome to redistribute it\nunder the conditions of the GNU General Public License.");
        if (args.length < 2) {
            ChromosomeToNetworkXml.printUsage();
            System.exit(-1);
        }
        ChromosomeToNetworkXml ctnx = new ChromosomeToNetworkXml();
        Properties props = new Properties(args[0]);
        ctnx.init(props);
        int i = 1;
        while (i < args.length) {
            String result2 = ctnx.toNetworkXml(args[i]);
            logger.info(result2);
            ++i;
        }
    }

    private static void printUsage() {
        System.err.println("<cmd> properties-file-name chromosome-id");
    }
}

