/*
 * Decompiled with CFR 0.152.
 */
package com.anji.integration;

import com.anji.util.Configurable;
import com.anji.util.Properties;
import java.io.PrintStream;
import org.jgap.Chromosome;
import org.jgap.Configuration;
import org.jgap.Genotype;
import org.jgap.event.GeneticEvent;
import org.jgap.event.GeneticEventListener;

public class ConsoleLogEventListener
implements GeneticEventListener,
Configurable {
    private PrintStream out = null;
    private Configuration config = null;

    public ConsoleLogEventListener(Configuration newConfig) {
        this(newConfig, System.out);
    }

    public ConsoleLogEventListener(Configuration newConfig, PrintStream newOut) {
        this.config = newConfig;
        this.out = newOut;
    }

    @Override
    public void init(Properties p) {
    }

    @Override
    public void geneticEventFired(GeneticEvent event) {
        if ("genotype_evolved_event".equals(event.getEventName())) {
            Genotype genotype = (Genotype)event.getSource();
            Chromosome fittest = genotype.getFittestChromosome();
            double maxFitnessValue = this.config.getBulkFitnessFunction() != null ? this.config.getBulkFitnessFunction().getMaxFitnessValue() : this.config.getFitnessFunction().getMaxFitnessValue();
            double fitness = maxFitnessValue == 0.0 ? (double)fittest.getFitnessValue() : (double)fittest.getFitnessValue() / maxFitnessValue;
            this.out.println("species count: " + genotype.getSpecies().size());
            this.out.println("fittest chromosome: " + fittest.getId() + ", score == " + fitness + " and # genes == " + fittest.size());
        }
    }
}

