/*
 * Decompiled with CFR 0.152.
 */
package com.anji.integration;

import com.anji.util.Properties;

public class ErrorFunction {
    private static final String TARGETS_RANGE_KEY = "targets.range";
    private double targetRange = 0.0;
    private static ErrorFunction instance = null;

    private ErrorFunction() {
    }

    public static ErrorFunction getInstance() {
        if (instance == null) {
            instance = new ErrorFunction();
        }
        return instance;
    }

    public void init(Properties props) {
        this.targetRange = props.getDoubleProperty(TARGETS_RANGE_KEY, 0.0);
    }

    public double getMaxError(int responseCount, double minMaxRange, boolean sumOfSquares) {
        double maxDiffPerResponse = minMaxRange - this.targetRange;
        if (sumOfSquares) {
            maxDiffPerResponse *= maxDiffPerResponse;
        }
        return maxDiffPerResponse * (double)responseCount;
    }

    public double calculateError(double[][] targets, double[][] responses, boolean sumOfSquares) {
        double result2 = 0.0;
        int i = 0;
        while (i < targets.length) {
            double[] response = responses[i];
            double[] target = targets[i];
            if (response.length != target.length) {
                throw new IllegalArgumentException("for training set " + i + " dimensions do not match for response [" + response.length + "] and target [" + target.length + "]");
            }
            int j = 0;
            while (j < target.length) {
                double diff = 0.0;
                if (response[j] > target[j] + this.targetRange) {
                    diff = response[j] - (target[j] + this.targetRange);
                } else if (response[j] < target[j] - this.targetRange) {
                    diff = target[j] - this.targetRange - response[j];
                }
                result2 = sumOfSquares ? (result2 += diff * diff) : (result2 += diff);
                ++j;
            }
            ++i;
        }
        return result2;
    }

    protected double getTargetRange() {
        return this.targetRange;
    }
}

