/*
 * Decompiled with CFR 0.152.
 */
package com.anji.integration;

import org.apache.log4j.Logger;

public class ErrorRateCounter {
    private static Logger logger = Logger.getLogger(ErrorRateCounter.class);
    private static ErrorRateCounter instance = null;

    private ErrorRateCounter() {
    }

    public static ErrorRateCounter getInstance() {
        if (instance == null) {
            instance = new ErrorRateCounter();
        }
        return instance;
    }

    public void countErrors(double[][] targets, double[][] responses) {
        this.countErrors("", targets, responses);
    }

    public void countErrors(String logPrefix, double[][] targets, double[][] responses) {
        int truePositives = 0;
        int falsePositives = 0;
        int trueNegatives = 0;
        int falseNegatives = 0;
        int i = 0;
        while (i < targets.length) {
            double[] response = responses[i];
            double[] target = targets[i];
            if (response.length != target.length) {
                throw new IllegalArgumentException(String.valueOf(logPrefix) + ": for training set " + i + " dimensions do not match for response [" + response.length + "] and target [" + target.length + "]");
            }
            int j = 0;
            while (j < target.length) {
                if (target[j] > 0.5) {
                    if (response[j] > 0.5) {
                        ++truePositives;
                    } else {
                        ++falseNegatives;
                    }
                } else if (response[j] > 0.5) {
                    ++falsePositives;
                } else {
                    ++trueNegatives;
                }
                ++j;
            }
            ++i;
        }
        logger.info(String.valueOf(logPrefix) + ": TP/FN/FP/TN: " + truePositives + "/" + falseNegatives + "/" + falsePositives + "/" + trueNegatives);
    }
}

