/*
 * Decompiled with CFR 0.152.
 */
package com.anji.integration;

import com.anji.persistence.Persistence;
import com.anji.util.DummyConfiguration;
import com.anji.util.Properties;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.jgap.BulkFitnessFunction;
import org.jgap.Chromosome;

public class Evaluator {
    private static final Logger logger = Logger.getLogger(Evaluator.class);

    private Evaluator() {
    }

    public static void main(String[] args) throws Exception {
        System.out.println("ANJI v2.0, Copyright (C) 2004 Derek James and Philip Tucker\nANJI comes with ABSOLUTELY NO WARRANTY\nThis is free software, and you are welcome to redistribute it\nunder the conditions of the GNU General Public License.");
        if (args.length < 2) {
            System.err.println("usage: <cmd> <properties-file> <chromosome-id1> [<chromosome-id2> <chromosome-id3> ...]");
            System.exit(-1);
        }
        Properties props = new Properties();
        props.loadFromResource(args[0]);
        BulkFitnessFunction fitnessFunc = (BulkFitnessFunction)props.singletonObjectProperty("fitness_function");
        Persistence db = (Persistence)props.newObjectProperty("persistence");
        DummyConfiguration config = new DummyConfiguration();
        ArrayList<Chromosome> chroms = new ArrayList<Chromosome>();
        int i = 1;
        while (i < args.length) {
            Chromosome chrom = db.loadChromosome(args[i], config);
            if (chrom == null) {
                throw new IllegalArgumentException("no chromosome found: " + args[i]);
            }
            chroms.add(chrom);
            ++i;
        }
        fitnessFunc.evaluate(chroms);
        for (Chromosome chrom : chroms) {
            logger.info(String.valueOf(chrom.toString()) + ": fitness = " + chrom.getFitnessValue() + "/" + fitnessFunc.getMaxFitnessValue());
        }
    }
}

