/*
 * Decompiled with CFR 0.152.
 */
package com.anji.integration;

import com.anji.integration.ErrorFunction;
import com.anji.integration.TargetFitnessFunction;
import com.anji.util.Properties;
import java.util.Arrays;

public class ExponentialTargetFitnessFunction
extends TargetFitnessFunction {
    private static final boolean SUM_OF_SQUARES = true;
    private double[][] nullResponses;
    private static final int MAX_FITNESS = Integer.MAX_VALUE;

    @Override
    public void init(Properties newProps) {
        try {
            super.init(newProps);
            ErrorFunction errorFunction = ErrorFunction.getInstance();
            errorFunction.init(newProps);
            this.nullResponses = new double[this.getTargets().length][this.getTargets()[0].length];
            int i = 0;
            while (i < this.nullResponses.length) {
                Arrays.fill(this.nullResponses[i], 0.0);
                ++i;
            }
            this.setMaxFitnessValue(Integer.MAX_VALUE);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid properties: " + e.getClass().toString() + ": " + e.getMessage());
        }
    }

    private double calculateSkewedFitness(double rawFitness, double expFactor, double nullRawFitness) {
        double exponent = expFactor * rawFitness - (nullRawFitness - Math.E);
        return Math.exp(exponent);
    }

    @Override
    protected int calculateErrorFitness(double[][] responses, double minResponse, double maxResponse) {
        ErrorFunction errorFunction = ErrorFunction.getInstance();
        double maxRawFitnessValue = errorFunction.getMaxError(this.getTargets().length * this.getTargets()[0].length, maxResponse - minResponse, true);
        double nullRawFitness = maxRawFitnessValue - errorFunction.calculateError(this.getTargets(), this.nullResponses, true);
        double expFactor = (Math.log(2.147483647E9) + (nullRawFitness - Math.E)) / maxRawFitnessValue;
        double sumSqDiff = ErrorFunction.getInstance().calculateError(this.getTargets(), responses, true);
        if (sumSqDiff > maxRawFitnessValue) {
            throw new IllegalStateException("sum squared diff > max fitness value");
        }
        double rawFitnessValue = maxRawFitnessValue - sumSqDiff;
        double skewedFitness = this.calculateSkewedFitness(rawFitnessValue, expFactor, nullRawFitness);
        int result2 = (int)skewedFitness;
        return result2;
    }
}

