/*
 * Decompiled with CFR 0.152.
 */
package com.anji.integration;

import com.anji.util.XmlPersistable;
import java.util.Iterator;
import org.jgap.Chromosome;
import org.jgap.Genotype;
import org.jgap.Specie;

public class Generation
implements XmlPersistable {
    public static final String GENERATION_TAG = "generation";
    private Genotype genotype;
    private Long id;
    private String cachedXml;

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        Generation other = (Generation)o;
        return this.id.equals(other.id);
    }

    private Generation() {
    }

    public Generation(Genotype aGenotype, long anId) {
        this.genotype = aGenotype;
        this.id = new Long(anId);
        this.cacheXml();
    }

    @Override
    public String toXml() {
        return this.cachedXml;
    }

    private void cacheXml() {
        int maxFitness = Integer.MIN_VALUE;
        int minFitness = Integer.MAX_VALUE;
        int maxComplexity = Integer.MIN_VALUE;
        int minComplexity = Integer.MAX_VALUE;
        StringBuffer result2 = new StringBuffer();
        result2.append("<").append(GENERATION_TAG).append(" id=\"").append(this.id).append("\" >\n");
        Iterator iter = this.genotype.getChromosomes().iterator();
        long runningFitnessTotal = 0L;
        int popSize = 0;
        long runningComplexityTotal = 0L;
        while (iter.hasNext()) {
            Chromosome chrom = (Chromosome)iter.next();
            int thisChromFitness = chrom.getFitnessValue();
            runningFitnessTotal += (long)thisChromFitness;
            int thisChromComplexity = chrom.size();
            runningComplexityTotal += (long)thisChromComplexity;
            ++popSize;
            if (thisChromFitness > maxFitness) {
                maxFitness = thisChromFitness;
            }
            if (thisChromFitness < minFitness) {
                minFitness = thisChromFitness;
            }
            if (thisChromComplexity > maxComplexity) {
                maxComplexity = thisChromComplexity;
            }
            if (thisChromComplexity >= minComplexity) continue;
            minComplexity = thisChromComplexity;
        }
        result2.append("<fitness>\n");
        result2.append("<max>").append(maxFitness);
        result2.append("</max>\n");
        result2.append("<min>").append(minFitness);
        result2.append("</min>\n");
        result2.append("<avg>");
        result2.append(runningFitnessTotal / (long)popSize);
        result2.append("</avg>\n");
        result2.append("</fitness>\n");
        result2.append("<complexity>\n");
        result2.append("<champ>").append(this.genotype.getFittestChromosome().size());
        result2.append("</champ>\n");
        result2.append("<max>").append(maxComplexity);
        result2.append("</max>\n");
        result2.append("<min>").append(minComplexity);
        result2.append("</min>\n");
        result2.append("<avg>");
        result2.append((double)runningComplexityTotal / (double)popSize);
        result2.append("</avg>\n");
        result2.append("</complexity>\n");
        for (Specie specie : this.genotype.getSpecies()) {
            result2.append(specie.toXml());
        }
        result2.append("</").append(GENERATION_TAG).append(">\n");
        this.cachedXml = result2.toString();
    }

    @Override
    public String getXmlRootTag() {
        return GENERATION_TAG;
    }

    @Override
    public String getXmld() {
        return null;
    }

    private Long getId() {
        return this.id;
    }

    private void setId(Long aId) {
        this.id = aId;
    }
}

