/*
 * Decompiled with CFR 0.152.
 */
package com.anji.integration;

import com.anji.util.Configurable;
import com.anji.util.Properties;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.jgap.Chromosome;
import org.jgap.Configuration;
import org.jgap.Genotype;
import org.jgap.event.GeneticEvent;
import org.jgap.event.GeneticEventListener;

public class LogEventListener
implements GeneticEventListener,
Configurable {
    private static Logger logger = Logger.getLogger(LogEventListener.class);
    private Configuration config = null;

    public LogEventListener(Configuration newConfig) {
        this.config = newConfig;
    }

    @Override
    public void init(Properties p) {
    }

    @Override
    public void geneticEventFired(GeneticEvent event) {
        if ("genotype_evolved_event".equals(event.getEventName())) {
            Genotype genotype = (Genotype)event.getSource();
            Chromosome fittest = genotype.getFittestChromosome();
            double maxFitnessValue = this.config.getBulkFitnessFunction() != null ? this.config.getBulkFitnessFunction().getMaxFitnessValue() : this.config.getFitnessFunction().getMaxFitnessValue();
            double fitness = maxFitnessValue == 0.0 ? (double)fittest.getFitnessValue() : (double)fittest.getFitnessValue() / maxFitnessValue;
            logger.info("species count: " + genotype.getSpecies().size());
            List chroms = genotype.getChromosomes();
            Iterator iter = chroms.iterator();
            int maxFitnessCount = 0;
            while (iter.hasNext()) {
                Chromosome c2 = (Chromosome)iter.next();
                if ((double)c2.getFitnessValue() != maxFitnessValue) continue;
                logger.info("max: id=" + c2.getId() + " score=" + fitness + " size=" + c2.size());
                ++maxFitnessCount;
            }
            logger.info("# chromosomes with max fitness: " + maxFitnessCount);
            logger.info("champ: id=" + fittest.getId() + " score=" + fitness + " size=" + fittest.size());
        }
    }
}

