/*
 * Decompiled with CFR 0.152.
 */
package com.anji.integration;

import com.anji.neat.NeatConfiguration;
import com.anji.persistence.Persistence;
import com.anji.run.Run;
import com.anji.util.Properties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jgap.Chromosome;
import org.jgap.Genotype;
import org.jgap.InvalidConfigurationException;
import org.jgap.event.GeneticEvent;
import org.jgap.event.GeneticEventListener;

public class PersistenceEventListener
implements GeneticEventListener {
    private static Logger logger = Logger.getLogger(PersistenceEventListener.class);
    public static final String PERSIST_ALL_CHROMOSOMES_KEY = "persist.all";
    public static final String PERSIST_CHAMPIONS_KEY = "persist.champions";
    public static final String PERSIST_LAST_GEN_KEY = "persist.last";
    private boolean persistAllChroms = false;
    private boolean persistChamps = false;
    private boolean persistLastGen = false;
    private Persistence db = null;
    private Collection previousGeneration = new ArrayList();
    private Collection champs = new ArrayList();
    private NeatConfiguration config;
    private Run run;

    public PersistenceEventListener(NeatConfiguration aConfig, Run aRun) {
        this.config = aConfig;
        this.run = aRun;
    }

    public void init(Properties props) {
        this.db = (Persistence)props.singletonObjectProperty("persistence");
        this.persistAllChroms = props.getBooleanProperty(PERSIST_ALL_CHROMOSOMES_KEY);
        this.persistChamps = props.getBooleanProperty(PERSIST_CHAMPIONS_KEY);
        this.persistLastGen = props.getBooleanProperty(PERSIST_LAST_GEN_KEY);
    }

    @Override
    public void geneticEventFired(GeneticEvent event) {
        Genotype genotype = (Genotype)event.getSource();
        if ("genotype_start_genetic_operators_event".equals(event.getEventName())) {
            this.genotypeStartGeneticOperatorsEvent();
        }
        if ("genotype_finish_genetic_operators_event".equals(event.getEventName())) {
            this.genotypeFinishGeneticOperatorsEvent();
        } else if ("genotype_evaluated_event".equals(event.getEventName())) {
            this.genotypeEvaluatedEvent(genotype);
        }
    }

    private void genotypeStartGeneticOperatorsEvent() {
        try {
            this.config.load();
        }
        catch (InvalidConfigurationException e) {
            logger.error("could not load configuration", e);
        }
    }

    private void genotypeFinishGeneticOperatorsEvent() {
        try {
            this.config.logIdMaps(logger, Priority.INFO);
            this.config.store();
        }
        catch (InvalidConfigurationException e) {
            logger.error("could not store configuration", e);
        }
    }

    private void genotypeEvaluatedEvent(Genotype genotype) {
        List currentGeneration = genotype.getChromosomes();
        if (this.persistAllChroms || this.persistLastGen) {
            Iterator iter = currentGeneration.iterator();
            while (iter.hasNext()) {
                this.storeChromosome((Chromosome)iter.next());
            }
        }
        Chromosome c22 = genotype.getFittestChromosome();
        this.champs.add(c22);
        if (this.persistChamps) {
            this.storeChromosome(c22);
        }
        try {
            this.db.store(this.run);
        }
        catch (Exception e) {
            logger.error("PersistenceEventListener: error storing run", e);
        }
        if (!this.persistAllChroms) {
            this.previousGeneration.removeAll(currentGeneration);
            if (this.persistChamps) {
                this.previousGeneration.removeAll(this.champs);
            }
            for (Chromosome c22 : this.previousGeneration) {
                try {
                    this.db.deleteChromosome(c22.getId().toString());
                }
                catch (Exception e) {
                    logger.error("error storing chromosome " + c22, e);
                }
            }
        }
        this.previousGeneration.clear();
        this.previousGeneration.addAll(currentGeneration);
    }

    private void storeChromosome(Chromosome chrom) {
        try {
            this.db.store(chrom);
        }
        catch (Exception e) {
            String msg = "PersistenceEventListener: error storing chromosome " + chrom.getId();
            logger.error(msg, e);
            throw new IllegalStateException(String.valueOf(msg) + ": " + e);
        }
    }
}

