/*
 * Decompiled with CFR 0.152.
 */
package com.anji.integration;

import com.anji.integration.XmlPersistableRun;
import com.anji.run.Run;
import com.anji.util.Properties;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import org.apache.log4j.Logger;
import org.jgap.event.GeneticEvent;
import org.jgap.event.GeneticEventListener;

public class PresentationEventListener
implements GeneticEventListener {
    public static final String BASE_DIR_KEY = "presentation.dir";
    private static final String FITNESS_DIR = "fitness/";
    private static final String FITNESS_FILE = "fitness.xml";
    private static final String SPECIES_DIR = "species/";
    private static final String SPECIES_FILE = "species.xml";
    private static final String COMPLEXITY_DIR = "complexity/";
    private static final String COMPLEXITY_FILE = "complexity.xml";
    private static Logger logger = Logger.getLogger(PresentationEventListener.class);
    private File fitnessDir;
    private File speciesDir;
    private File complexityDir;
    private Run run;

    private static File mkdir(String path) {
        File result2 = new File(path);
        result2.mkdirs();
        if (!result2.exists()) {
            throw new IllegalArgumentException("base directory does not exist: " + path);
        }
        if (!result2.isDirectory()) {
            throw new IllegalArgumentException("base directory is a file: " + path);
        }
        if (!result2.canWrite()) {
            throw new IllegalArgumentException("base directory not writable: " + path);
        }
        return result2;
    }

    public PresentationEventListener(Run aRun) {
        this.run = aRun;
    }

    public void init(Properties props) {
        String basePath = props.getProperty(BASE_DIR_KEY);
        this.fitnessDir = PresentationEventListener.mkdir(String.valueOf(basePath) + File.separator + FITNESS_DIR);
        this.speciesDir = PresentationEventListener.mkdir(String.valueOf(basePath) + File.separator + SPECIES_DIR);
        this.complexityDir = PresentationEventListener.mkdir(String.valueOf(basePath) + File.separator + COMPLEXITY_DIR);
    }

    @Override
    public void geneticEventFired(GeneticEvent event) {
        if ("genotype_evaluated_event".equals(event.getEventName())) {
            this.storeRun(false);
        } else if ("run_completed_event".equals(event.getEventName())) {
            this.storeRun(true);
        }
    }

    public void storeRun(boolean isRunCompleted) {
        OutputStreamWriter fitnessOut = null;
        OutputStreamWriter speciesOut = null;
        OutputStreamWriter complexityOut = null;
        try {
            try {
                fitnessOut = new FileWriter(String.valueOf(this.fitnessDir.getAbsolutePath()) + File.separator + FITNESS_FILE);
                speciesOut = new FileWriter(String.valueOf(this.speciesDir.getAbsolutePath()) + File.separator + SPECIES_FILE);
                complexityOut = new FileWriter(String.valueOf(this.complexityDir.getAbsolutePath()) + File.separator + COMPLEXITY_FILE);
                XmlPersistableRun xmlRun = new XmlPersistableRun(this.run);
                complexityOut.write(xmlRun.toComplexityString(isRunCompleted));
                fitnessOut.write(xmlRun.toFitnessString(isRunCompleted));
                speciesOut.write(xmlRun.toSpeciesString(isRunCompleted));
            }
            catch (Throwable e) {
                logger.error("PresentationEventListener: error storing run", e);
                try {
                    if (complexityOut != null) {
                        complexityOut.close();
                    }
                    if (speciesOut != null) {
                        speciesOut.close();
                    }
                    if (fitnessOut != null) {
                        fitnessOut.close();
                    }
                }
                catch (Exception e2) {
                    logger.error("error closing presentation files");
                }
            }
        }
        finally {
            try {
                if (complexityOut != null) {
                    complexityOut.close();
                }
                if (speciesOut != null) {
                    speciesOut.close();
                }
                if (fitnessOut != null) {
                    fitnessOut.close();
                }
            }
            catch (Exception e) {
                logger.error("error closing presentation files");
            }
        }
    }
}

