/*
 * Decompiled with CFR 0.152.
 */
package com.anji.integration;

import com.anji.integration.Activator;
import com.anji.integration.ActivatorTranscriber;
import com.anji.integration.TranscriberException;
import com.anji.util.Configurable;
import com.anji.util.Properties;
import com.anji.util.Randomizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.jgap.BulkFitnessFunction;
import org.jgap.Chromosome;

public abstract class TargetFitnessFunction
implements BulkFitnessFunction,
Configurable {
    private static Logger logger = Logger.getLogger(TargetFitnessFunction.class);
    private static final String ADJUST_FOR_NETWORK_SIZE_FACTOR_KEY = "fitness.function.adjust.for.network.size.factor";
    private float adjustForNetworkSizeFactor = 0.0f;
    public static final String STIMULI_FILE_NAME_KEY = "stimuli.file";
    public static final String TARGETS_FILE_NAME_KEY = "targets.file";
    private static final String TARGETS_RANGE_KEY = "targets.range";
    private double[][] stimuli;
    private double[][] targets;
    private double targetRange = 0.0;
    private int maxFitnessValue;
    private ActivatorTranscriber activatorFactory;
    private Randomizer randomizer;

    @Override
    public void init(Properties props) {
        try {
            this.randomizer = (Randomizer)props.singletonObjectProperty(Randomizer.class);
            this.activatorFactory = (ActivatorTranscriber)props.singletonObjectProperty(ActivatorTranscriber.class);
            this.stimuli = Properties.loadArrayFromFile(props.getResourceProperty(STIMULI_FILE_NAME_KEY));
            this.targets = Properties.loadArrayFromFile(props.getResourceProperty(TARGETS_FILE_NAME_KEY));
            this.targetRange = props.getDoubleProperty(TARGETS_RANGE_KEY, 0.0);
            this.adjustForNetworkSizeFactor = props.getFloatProperty(ADJUST_FOR_NETWORK_SIZE_FACTOR_KEY, 0.0f);
            if (this.stimuli.length == 0 || this.targets.length == 0) {
                throw new IllegalArgumentException("require at least 1 training set for stimuli [" + this.stimuli.length + "] and targets [" + this.targets.length + "]");
            }
            if (this.stimuli.length != this.targets.length) {
                throw new IllegalArgumentException("# training sets does not match for stimuli [" + this.stimuli.length + "] and targets [" + this.targets.length + "]");
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid properties: " + e.getClass().toString() + ": " + e.getMessage());
        }
    }

    protected void setMaxFitnessValue(int aMaxFitnessValue) {
        int minGenes = this.stimuli[0].length + this.targets[0].length;
        this.maxFitnessValue = aMaxFitnessValue - (int)(this.adjustForNetworkSizeFactor * (float)minGenes);
    }

    @Override
    public final void evaluate(List genotypes) {
        for (Chromosome genotype : genotypes) {
            try {
                Activator activator = this.activatorFactory.newActivator(genotype);
                ArrayList<Integer> idxs = new ArrayList<Integer>();
                int i = 0;
                while (i < this.stimuli.length) {
                    idxs.add(new Integer(i));
                    ++i;
                }
                Collections.shuffle(idxs, this.randomizer.getRand());
                Iterator iter = idxs.iterator();
                double[][] shuffledStimuli = new double[this.stimuli.length][this.stimuli[0].length];
                int k = 0;
                while (iter.hasNext()) {
                    Integer idx = (Integer)iter.next();
                    int i2 = idx;
                    int j = 0;
                    while (j < this.stimuli[0].length) {
                        shuffledStimuli[k][j] = this.stimuli[i2][j];
                        ++j;
                    }
                    ++k;
                }
                double[][] shuffledResponses = activator.next(shuffledStimuli);
                double[][] responses = new double[shuffledResponses.length][1];
                int i3 = 0;
                while (i3 < responses.length) {
                    Integer idx = (Integer)idxs.get(i3);
                    responses[idx.intValue()] = shuffledResponses[i3];
                    ++i3;
                }
                genotype.setFitnessValue(this.calculateErrorFitness(responses, activator.getMinResponse(), activator.getMaxResponse()) - (int)(this.adjustForNetworkSizeFactor * (float)genotype.size()));
            }
            catch (TranscriberException e) {
                logger.warn("transcriber error: " + e.getMessage());
                genotype.setFitnessValue(1);
            }
        }
    }

    protected abstract int calculateErrorFitness(double[][] var1, double var2, double var4);

    protected double getTargetRange() {
        return this.targetRange;
    }

    protected double[][] getStimuli() {
        return this.stimuli;
    }

    protected double[][] getTargets() {
        return this.targets;
    }

    @Override
    public int getMaxFitnessValue() {
        return this.maxFitnessValue;
    }
}

