/*
 * Decompiled with CFR 0.152.
 */
package com.anji.integration;

import com.anji.neat.ConnectionAllele;
import com.anji.neat.ConnectionGene;
import com.anji.neat.NeuronAllele;
import com.anji.neat.NeuronGene;
import com.anji.neat.NeuronType;
import com.anji.nn.ActivationFunctionType;
import com.anji.util.XmlPersistable;
import org.jgap.Allele;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XmlPersistableAllele
implements XmlPersistable {
    public static final String NEURON_XML_TAG = "neuron";
    private static final String NEURON_XML_TYPE_TAG = "type";
    private static final String NEURON_XML_ACTIVATION_TYPE_TAG = "activation";
    public static final String CONN_XML_TAG = "connection";
    private static final String XML_ID_TAG = "id";
    private static final String CONN_XML_SRCID_TAG = "src-id";
    private static final String CONN_XML_DESTID_TAG = "dest-id";
    private static final String CONN_XML_WEIGHT_TAG = "weight";
    private static final String CONN_XML_RECURRENT_TAG = "recurrent";
    private Allele allele;

    public XmlPersistableAllele(Allele aAllele) {
        this.allele = aAllele;
    }

    @Override
    public String toXml() {
        StringBuffer result2 = new StringBuffer();
        if (this.allele instanceof NeuronAllele) {
            NeuronAllele nAllele = (NeuronAllele)this.allele;
            result2.append("<").append(NEURON_XML_TAG).append(" ");
            result2.append(XML_ID_TAG).append("=\"").append(this.allele.getInnovationId()).append("\" ");
            result2.append(NEURON_XML_TYPE_TAG).append("=\"").append(nAllele.getType().toString()).append("\" ");
            result2.append(NEURON_XML_ACTIVATION_TYPE_TAG).append("=\"").append(nAllele.getActivationType().toString());
            result2.append("\"/>\n");
        } else if (this.allele instanceof ConnectionAllele) {
            ConnectionAllele cAllele = (ConnectionAllele)this.allele;
            result2.append("<").append(CONN_XML_TAG).append(" ");
            result2.append(XML_ID_TAG).append("=\"").append(this.allele.getInnovationId());
            result2.append("\" ").append(CONN_XML_SRCID_TAG).append("=\"").append(cAllele.getSrcNeuronId());
            result2.append("\" ").append(CONN_XML_DESTID_TAG).append("=\"").append(cAllele.getDestNeuronId());
            result2.append("\" ").append(CONN_XML_WEIGHT_TAG).append("=\"").append(cAllele.getWeight()).append("\"/>\n");
        }
        return result2.toString();
    }

    @Override
    public String getXmlRootTag() {
        if (this.allele instanceof NeuronAllele) {
            return NEURON_XML_TAG;
        }
        if (this.allele instanceof ConnectionAllele) {
            return CONN_XML_TAG;
        }
        return null;
    }

    @Override
    public String getXmld() {
        return this.allele.getInnovationId().toString();
    }

    public static NeuronAllele neuronFromXml(Node node) throws IllegalArgumentException {
        if (!NEURON_XML_TAG.equals(node.getNodeName())) {
            throw new IllegalArgumentException("tag != neuron");
        }
        if (!node.hasAttributes()) {
            throw new IllegalArgumentException("no attributes");
        }
        NamedNodeMap atts = node.getAttributes();
        String str = atts.getNamedItem(NEURON_XML_TYPE_TAG).getNodeValue();
        NeuronType type = NeuronType.valueOf(str);
        if (type == null) {
            throw new IllegalArgumentException("invalid neuron type: " + str);
        }
        str = atts.getNamedItem(XML_ID_TAG).getNodeValue();
        Long id = Long.valueOf(str);
        ActivationFunctionType activationType = ActivationFunctionType.SIGMOID;
        Node actNode = atts.getNamedItem(NEURON_XML_ACTIVATION_TYPE_TAG);
        if (actNode != null && (activationType = ActivationFunctionType.valueOf(str = actNode.getNodeValue())) == null) {
            throw new IllegalArgumentException("invalid activation function type: " + str);
        }
        return new NeuronAllele(new NeuronGene(type, id, activationType));
    }

    public static ConnectionAllele connectionFromXml(Node node) throws IllegalArgumentException {
        if (!CONN_XML_TAG.equals(node.getNodeName())) {
            throw new IllegalArgumentException("tag != connection");
        }
        if (!node.hasAttributes()) {
            throw new IllegalArgumentException("no attributes");
        }
        NamedNodeMap atts = node.getAttributes();
        String idStr = atts.getNamedItem(XML_ID_TAG).getNodeValue();
        Long id = Long.valueOf(idStr);
        String srcIdStr = atts.getNamedItem(CONN_XML_SRCID_TAG).getNodeValue();
        Long srcId = Long.valueOf(srcIdStr);
        String destIdStr = atts.getNamedItem(CONN_XML_DESTID_TAG).getNodeValue();
        Long destId = Long.valueOf(destIdStr);
        ConnectionAllele result2 = new ConnectionAllele(new ConnectionGene(id, srcId, destId));
        String weightStr = atts.getNamedItem(CONN_XML_WEIGHT_TAG).getNodeValue();
        result2.setWeight(Double.parseDouble(weightStr));
        return result2;
    }
}

