/*
 * Decompiled with CFR 0.152.
 */
package com.anji.integration;

import com.anji.integration.XmlPersistableAllele;
import com.anji.util.XmlPersistable;
import org.jgap.Allele;
import org.jgap.Chromosome;

public class XmlPersistableChromosome
implements XmlPersistable {
    public static final String XML_CHROMOSOME_TAG = "chromosome";
    public static final String XML_CHROMOSOME_ID_TAG = "id";
    public static final String XML_CHROMOSOME_PRIMARY_PARENT_ID_TAG = "primary-parent-id";
    public static final String XML_CHROMOSOME_SECONDARY_PARENT_ID_TAG = "secondary-parent-id";
    private Chromosome chromosome;

    public XmlPersistableChromosome(Chromosome aChromosome) {
        this.chromosome = aChromosome;
    }

    @Override
    public String toXml() {
        StringBuffer result2 = new StringBuffer();
        result2.append("<").append(XML_CHROMOSOME_TAG);
        result2.append(" ").append(XML_CHROMOSOME_ID_TAG).append("=\"").append(this.chromosome.getId());
        if (this.chromosome.getPrimaryParentId() != null) {
            result2.append("\" ").append(XML_CHROMOSOME_PRIMARY_PARENT_ID_TAG);
            result2.append("=\"").append(this.chromosome.getPrimaryParentId());
        }
        if (this.chromosome.getSecondaryParentId() != null) {
            result2.append("\" ").append(XML_CHROMOSOME_SECONDARY_PARENT_ID_TAG);
            result2.append("=\"").append(this.chromosome.getSecondaryParentId());
        }
        result2.append("\">");
        for (Allele allele : this.chromosome.getAlleles()) {
            XmlPersistableAllele xmlAllele = new XmlPersistableAllele(allele);
            result2.append(xmlAllele.toXml());
        }
        result2.append("</").append(XML_CHROMOSOME_TAG).append(">");
        return result2.toString();
    }

    @Override
    public String getXmlRootTag() {
        return XML_CHROMOSOME_TAG;
    }

    @Override
    public String getXmld() {
        Long id = this.chromosome.getId();
        return id == null ? "" : id.toString();
    }
}

