/*
 * Decompiled with CFR 0.152.
 */
package com.anji.integration;

import com.anji.integration.Generation;
import com.anji.run.Run;
import com.anji.util.Properties;
import com.anji.util.XmlPersistable;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class XmlPersistableRun
implements XmlPersistable {
    public static final String RUN_TAG = "run";
    public static final String PARAMETERS_TAG = "parameters";
    private Run run;
    public static final String PARAMETER_TAG = "parameter";
    private static final String vers = "<?xml version = \"1.0\" encoding = \"UTF-8\"?>\n";
    private static final String dtd = "<!DOCTYPE run SYSTEM \"../run.dtd\">\n";
    private static final String endTag = "</run>\n";
    private static final String complexityStylesheet = "<?xml-stylesheet type=\"text/xsl\" href=\"./graphComplexity.xsl\" ?>\n";
    private static final String complexityRefreshStylesheet = "<?xml-stylesheet type=\"text/xsl\" href=\"./graphComplexityRefresh.xsl\" ?>\n";
    private static final String fitnessStylesheet = "<?xml-stylesheet type=\"text/xsl\" href=\"./graphFitness.xsl\" ?>\n";
    private static final String fitnessRefreshStylesheet = "<?xml-stylesheet type=\"text/xsl\" href=\"./graphFitnessRefresh.xsl\" ?>\n";
    private static final String speciesStylesheet = "<?xml-stylesheet type=\"text/xsl\" href=\"./graphSpecies.xsl\" ?>\n";
    private static final String speciesRefreshStylesheet = "<?xml-stylesheet type=\"text/xsl\" href=\"./graphSpeciesRefresh.xsl\" ?>\n";
    private StringBuffer params = new StringBuffer();
    private String cachedRunXml;

    public XmlPersistableRun(Run aRun) {
        this.run = aRun;
        Properties props = this.run.getProps();
        if (props != null) {
            this.params.append("<search-parameters>\n");
            this.params.append("<population-size>").append(props.getIntProperty("popul.size")).append("</population-size>\n");
            this.params.append("<generations>").append(props.getIntProperty("num.generations")).append("</generations>\n");
            this.params.append("</search-parameters>\n");
        }
        this.cachedRunXml = null;
    }

    protected void appendToString(boolean includeDtd, StringBuffer result2) {
        if (this.cachedRunXml == null) {
            StringBuffer cacheBuffer = new StringBuffer();
            if (includeDtd) {
                cacheBuffer.append(dtd);
            }
            SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd HH:mm:ss");
            String startTag = "<run name=\"" + this.run.getName() + "\" timedatestamp=\"[" + fmt.format(this.run.getStartTime().getTime()) + " - " + fmt.format(Calendar.getInstance().getTime()) + "]\" >\n";
            cacheBuffer.append(startTag);
            cacheBuffer.append(this.params);
            for (Generation g : this.run.getGenerations()) {
                cacheBuffer.append(g.toXml());
            }
            cacheBuffer.append(endTag);
            this.cachedRunXml = cacheBuffer.toString();
        }
        result2.append(this.cachedRunXml);
    }

    public String toComplexityString(boolean isRunCompleted) {
        StringBuffer result2 = new StringBuffer();
        result2.append(vers);
        result2.append(isRunCompleted ? complexityStylesheet : complexityRefreshStylesheet);
        this.appendToString(true, result2);
        return result2.toString();
    }

    public String toFitnessString(boolean isRunCompleted) {
        StringBuffer result2 = new StringBuffer();
        result2.append(vers);
        result2.append(isRunCompleted ? fitnessStylesheet : fitnessRefreshStylesheet);
        this.appendToString(true, result2);
        return result2.toString();
    }

    public String toSpeciesString(boolean isRunCompleted) {
        StringBuffer result2 = new StringBuffer();
        result2.append(vers);
        result2.append(isRunCompleted ? speciesStylesheet : speciesRefreshStylesheet);
        this.appendToString(true, result2);
        return result2.toString();
    }

    public String toString() {
        return this.toXml();
    }

    @Override
    public String toXml() {
        StringBuffer result2 = new StringBuffer();
        this.appendToString(false, result2);
        return result2.toString();
    }

    @Override
    public String getXmlRootTag() {
        return RUN_TAG;
    }

    @Override
    public String getXmld() {
        return this.run.getName();
    }

    public String getName() {
        return this.run.getName();
    }
}

