/*
 * Decompiled with CFR 0.152.
 */
package com.anji.neat;

import com.anji.integration.AnjiRequiredException;
import com.anji.neat.ConnectionAllele;
import com.anji.neat.NeatChromosomeUtility;
import com.anji.neat.NeatConfiguration;
import com.anji.neat.NeuronAllele;
import com.anji.neat.NeuronType;
import com.anji.nn.ActivationFunctionType;
import com.anji.nn.RecurrencyPolicy;
import com.anji.util.Configurable;
import com.anji.util.Properties;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import org.jgap.Allele;
import org.jgap.ChromosomeMaterial;
import org.jgap.Configuration;
import org.jgap.MutationOperator;

public class AddConnectionMutationOperator
extends MutationOperator
implements Configurable {
    public static final String ADD_CONN_MUTATE_RATE_KEY = "add.connection.mutation.rate";
    public static final float DEFAULT_MUTATE_RATE = 0.01f;
    private RecurrencyPolicy policy;

    @Override
    public void init(Properties props) throws Exception {
        this.setMutationRate(props.getFloatProperty(ADD_CONN_MUTATE_RATE_KEY, 0.01f));
        this.policy = RecurrencyPolicy.load(props);
    }

    public AddConnectionMutationOperator() {
        this(0.01f, RecurrencyPolicy.BEST_GUESS);
    }

    public AddConnectionMutationOperator(float newMutationRate) {
        this(newMutationRate, RecurrencyPolicy.BEST_GUESS);
    }

    public AddConnectionMutationOperator(RecurrencyPolicy aPolicy) {
        this(0.01f, aPolicy);
    }

    public AddConnectionMutationOperator(float aMutationRate, RecurrencyPolicy aPolicy) {
        super(aMutationRate);
        this.policy = aPolicy;
    }

    @Override
    protected void mutate(Configuration jgapConfig, ChromosomeMaterial target, Set allelesToAdd, Set allelesToRemove) {
        if (!(jgapConfig instanceof NeatConfiguration)) {
            throw new AnjiRequiredException("com.anji.neat.NeatConfiguration");
        }
        NeatConfiguration config = (NeatConfiguration)jgapConfig;
        List neuronList = NeatChromosomeUtility.getNeuronList(target.getAlleles());
        SortedMap conns = NeatChromosomeUtility.getConnectionMap(target.getAlleles());
        int maxConnectionsToAdd = neuronList.size() * neuronList.size() - conns.size();
        int numConnectionsToAdd = this.numMutations(config.getRandomGenerator(), maxConnectionsToAdd);
        this.addConnections(numConnectionsToAdd, config, neuronList, conns, allelesToAdd);
    }

    private void addConnections(int numConnectionsToAdd, NeatConfiguration config, List neuronList, SortedMap conns, Set allelesToAdd) {
        HashSet<Long> rejectedConnIds = new HashSet<Long>();
        int i = 0;
        while (i < numConnectionsToAdd) {
            Allele newConn = null;
            NeuronAllele src = null;
            NeuronAllele dest = null;
            while (newConn == null) {
                int srcIdx = config.getRandomGenerator().nextInt(neuronList.size());
                int destIdx = config.getRandomGenerator().nextInt(neuronList.size());
                src = (NeuronAllele)neuronList.get(srcIdx);
                dest = (NeuronAllele)neuronList.get(destIdx);
                newConn = config.newConnectionAllele(src.getInnovationId(), dest.getInnovationId());
                if (!conns.containsKey(newConn.getInnovationId()) && !rejectedConnIds.contains(newConn.getInnovationId())) continue;
                newConn = null;
            }
            if (this.connectionAllowed(src, dest, conns)) {
                conns.put(newConn.getInnovationId(), newConn);
                ((ConnectionAllele)newConn).setToRandomValue(config.getRandomGenerator());
                allelesToAdd.add(newConn);
            } else {
                rejectedConnIds.add(newConn.getInnovationId());
            }
            ++i;
        }
    }

    public void addSingleConnection(NeatConfiguration config, List neuronList, SortedMap conns, Set allelesToAdd) {
        HashSet<Long> rejectedConnIds = new HashSet<Long>();
        boolean isAdded = false;
        int maxConnections = neuronList.size() * neuronList.size() - conns.size();
        while (!isAdded && rejectedConnIds.size() < maxConnections) {
            Allele newConn = null;
            NeuronAllele src = null;
            NeuronAllele dest = null;
            while (newConn == null) {
                int srcIdx = config.getRandomGenerator().nextInt(neuronList.size());
                int destIdx = config.getRandomGenerator().nextInt(neuronList.size());
                src = (NeuronAllele)neuronList.get(srcIdx);
                dest = (NeuronAllele)neuronList.get(destIdx);
                newConn = config.newConnectionAllele(src.getInnovationId(), dest.getInnovationId());
                if (!conns.containsKey(newConn.getInnovationId()) && !rejectedConnIds.contains(newConn.getInnovationId())) continue;
                newConn = null;
            }
            if (this.connectionAllowed(src, dest, conns)) {
                conns.put(newConn.getInnovationId(), newConn);
                ((ConnectionAllele)newConn).setToRandomValue(config.getRandomGenerator());
                allelesToAdd.add(newConn);
                isAdded = true;
                continue;
            }
            rejectedConnIds.add(newConn.getInnovationId());
        }
    }

    private boolean connectionAllowed(NeuronAllele src, NeuronAllele dest, SortedMap conns) {
        if (RecurrencyPolicy.DISALLOWED.equals(this.policy)) {
            if (dest.isType(NeuronType.INPUT) || src.isType(NeuronType.OUTPUT)) {
                return false;
            }
            boolean connected = NeatChromosomeUtility.neuronsAreConnected(dest.getInnovationId(), src.getInnovationId(), conns.values());
            return !connected;
        }
        return !ActivationFunctionType.LINEAR.equals(dest.getActivationType());
    }
}

