/*
 * Decompiled with CFR 0.152.
 */
package com.anji.neat;

import com.anji.integration.AnjiRequiredException;
import com.anji.neat.ConnectionAllele;
import com.anji.neat.NeatChromosomeUtility;
import com.anji.neat.NeatConfiguration;
import com.anji.neat.NeuronAllele;
import com.anji.util.Configurable;
import com.anji.util.Properties;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.jgap.ChromosomeMaterial;
import org.jgap.Configuration;
import org.jgap.MutationOperator;

public class AddNeuronMutationOperator
extends MutationOperator
implements Configurable {
    public static final String ADD_NEURON_MUTATE_RATE_KEY = "add.neuron.mutation.rate";
    public static final float DEFAULT_MUTATE_RATE = 0.01f;

    @Override
    public void init(Properties props) throws Exception {
        this.setMutationRate(props.getFloatProperty(ADD_NEURON_MUTATE_RATE_KEY, 0.01f));
    }

    public AddNeuronMutationOperator() {
        this(0.01f);
    }

    public AddNeuronMutationOperator(float newMutationRate) {
        super(newMutationRate);
    }

    @Override
    protected void mutate(Configuration jgapConfig, ChromosomeMaterial target, Set allelesToAdd, Set allelesToRemove) {
        if (!(jgapConfig instanceof NeatConfiguration)) {
            throw new AnjiRequiredException("com.anji.neat.NeatConfiguration");
        }
        NeatConfiguration config = (NeatConfiguration)jgapConfig;
        SortedMap neurons = NeatChromosomeUtility.getNeuronMap(target.getAlleles());
        List connList = NeatChromosomeUtility.getConnectionList(target.getAlleles());
        Collections.shuffle(connList, config.getRandomGenerator());
        int numConnections = this.numMutations(config.getRandomGenerator(), connList.size());
        Iterator iter = connList.iterator();
        int count = 0;
        while (iter.hasNext() && count++ < numConnections) {
            ConnectionAllele oldConnectAllele = (ConnectionAllele)iter.next();
            this.addNeuronAtConnection(config, neurons, oldConnectAllele, allelesToAdd, allelesToRemove);
        }
    }

    public boolean addNeuronAtConnection(NeatConfiguration config, Map neurons, ConnectionAllele oldConnectAllele, Set allelesToAdd, Set allelesToRemove) {
        NeuronAllele newNeuronAllele = config.newNeuronAllele(oldConnectAllele.getInnovationId());
        if (!neurons.containsKey(newNeuronAllele.getInnovationId())) {
            neurons.put(newNeuronAllele.getInnovationId(), newNeuronAllele);
            ConnectionAllele newConnectAllele1 = config.newConnectionAllele(oldConnectAllele.getSrcNeuronId(), newNeuronAllele.getInnovationId());
            newConnectAllele1.setWeight(1.0);
            ConnectionAllele newConnectAllele2 = config.newConnectionAllele(newNeuronAllele.getInnovationId(), oldConnectAllele.getDestNeuronId());
            newConnectAllele2.setWeight(oldConnectAllele.getWeight());
            allelesToRemove.add(oldConnectAllele);
            allelesToAdd.add(newNeuronAllele);
            allelesToAdd.add(newConnectAllele1);
            allelesToAdd.add(newConnectAllele2);
            return true;
        }
        return false;
    }
}

