/*
 * Decompiled with CFR 0.152.
 */
package com.anji.neat;

import com.anji.neat.ConnectionGene;
import java.util.Random;
import org.jgap.Allele;

public class ConnectionAllele
extends Allele {
    private ConnectionGene connectionGene;
    public static final double DEFAULT_WEIGHT = 0.0;
    private static final double MIN_INIT_WEIGHT = -1.0;
    private static final double MAX_INIT_WEIGHT = 1.0;
    private double weight = 0.0;

    @Override
    public String toString() {
        return String.valueOf(this.connectionGene.toString()) + " [" + this.weight + "]";
    }

    private ConnectionAllele() {
    }

    public ConnectionAllele(ConnectionGene aConnectionGene) {
        super(aConnectionGene);
        this.connectionGene = aConnectionGene;
    }

    @Override
    public Allele cloneAllele() {
        ConnectionAllele allele = new ConnectionAllele(this.connectionGene);
        allele.setWeight(this.weight);
        return allele;
    }

    @Override
    public double distance(Allele target) {
        return Math.abs(this.weight - ((ConnectionAllele)target).getWeight());
    }

    @Override
    public void setToRandomValue(Random a_numberGenerator) {
        this.weight = -1.0 + (double)a_numberGenerator.nextFloat() * 2.0;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double aWeight) {
        this.weight = aWeight;
    }

    public Long getSrcNeuronId() {
        return this.connectionGene.getSrcNeuronId();
    }

    public Long getDestNeuronId() {
        return this.connectionGene.getDestNeuronId();
    }
}

