/*
 * Decompiled with CFR 0.152.
 */
package com.anji.neat;

import com.anji.integration.LogEventListener;
import com.anji.integration.PersistenceEventListener;
import com.anji.integration.PresentationEventListener;
import com.anji.neat.NeatChromosomeUtility;
import com.anji.neat.NeatConfiguration;
import com.anji.neat.NeuronType;
import com.anji.persistence.Persistence;
import com.anji.run.Run;
import com.anji.util.Configurable;
import com.anji.util.Properties;
import com.anji.util.Reset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.jgap.BulkFitnessFunction;
import org.jgap.Chromosome;
import org.jgap.ChromosomeMaterial;
import org.jgap.Genotype;
import org.jgap.event.GeneticEvent;

public class Evolver
implements Configurable {
    private static Logger logger = Logger.getLogger(Evolver.class);
    public static final String NUM_GENERATIONS_KEY = "num.generations";
    public static final String FITNESS_FUNCTION_CLASS_KEY = "fitness_function";
    private static final String FITNESS_THRESHOLD_KEY = "fitness.threshold";
    private static final String RESET_KEY = "run.reset";
    public static final String FITNESS_TARGET_KEY = "fitness.target";
    private NeatConfiguration config = null;
    private Chromosome champ = null;
    private Genotype genotype = null;
    private int numEvolutions = 0;
    private double targetFitness = 0.0;
    private double thresholdFitness = 0.0;
    private int maxFitness = 0;
    private Persistence db = null;
    private Date aquamarinRunStartDate;
    private DateFormat aquamarinFmt;
    private int aquamarinGenerationOfFirstSolution;
    private double aquamarinAdjustedFitness;
    private int aquamarinGeneration = 0;
    Date aquamarinGenerationStartDate;
    private String name;

    @Override
    public void init(Properties props) throws Exception {
        boolean doReset = props.getBooleanProperty(RESET_KEY, false);
        if (doReset) {
            logger.warn("Resetting previous run !!!");
            Reset resetter = new Reset(props);
            resetter.setUserInteraction(false);
            resetter.reset();
        }
        this.config = new NeatConfiguration(props);
        this.db = (Persistence)props.singletonObjectProperty("persistence");
        this.numEvolutions = props.getIntProperty(NUM_GENERATIONS_KEY);
        this.targetFitness = props.getDoubleProperty(FITNESS_TARGET_KEY, 1.0);
        this.thresholdFitness = props.getDoubleProperty(FITNESS_THRESHOLD_KEY, this.targetFitness);
        Run run = (Run)props.singletonObjectProperty(Run.class);
        this.db.startRun(run.getName());
        this.config.getEventManager().addEventListener("genotype_evaluated_event", run);
        LogEventListener logListener = new LogEventListener(this.config);
        this.config.getEventManager().addEventListener("genotype_evolved_event", logListener);
        this.config.getEventManager().addEventListener("genotype_evaluated_event", logListener);
        PersistenceEventListener dbListener = new PersistenceEventListener(this.config, run);
        dbListener.init(props);
        this.config.getEventManager().addEventListener("genotype_start_genetic_operators_event", dbListener);
        this.config.getEventManager().addEventListener("genotype_finish_genetic_operators_event", dbListener);
        this.config.getEventManager().addEventListener("genotype_evaluated_event", dbListener);
        PresentationEventListener presListener = new PresentationEventListener(run);
        presListener.init(props);
        this.config.getEventManager().addEventListener("genotype_evaluated_event", presListener);
        this.config.getEventManager().addEventListener("run_completed_event", presListener);
        BulkFitnessFunction fitnessFunc = (BulkFitnessFunction)props.singletonObjectProperty(FITNESS_FUNCTION_CLASS_KEY);
        this.config.setBulkFitnessFunction(fitnessFunc);
        this.maxFitness = fitnessFunc.getMaxFitnessValue();
        this.genotype = this.db.loadGenotype(this.config);
        if (this.genotype != null) {
            logger.info("genotype from previous run");
        } else {
            this.genotype = Genotype.randomInitialGenotype(this.config);
            logger.info("random genotype");
        }
    }

    private static void usage() {
        System.err.println("usage: <cmd> <properties-file>");
    }

    public Evolver run() throws Exception {
        this.aquamarinRunStartDate = Calendar.getInstance().getTime();
        logger.info("Run: start");
        this.aquamarinFmt = new SimpleDateFormat("HH:mm:ss");
        this.aquamarinGenerationOfFirstSolution = -1;
        this.champ = this.genotype.getFittestChromosome();
        this.aquamarinAdjustedFitness = this.maxFitness > 0 ? this.champ.getFitnessValue() / this.maxFitness : this.champ.getFitnessValue();
        return this;
    }

    public List<Chromosome> nextGeneration() {
        this.aquamarinGenerationStartDate = Calendar.getInstance().getTime();
        logger.info("Generation " + this.aquamarinGeneration++ + ": start");
        return this.genotype.getChromosomes();
    }

    public void evolveGeneration() {
        this.genotype.evolve();
        this.champ = this.genotype.getFittestChromosome();
        System.out.println("Evolver(" + this.name + ").evolveGeneration.champ.size: " + this.champ.getAlleles().size());
        double d = this.aquamarinAdjustedFitness = this.maxFitness > 0 ? (double)this.champ.getFitnessValue() / (double)this.maxFitness : (double)this.champ.getFitnessValue();
        if (this.aquamarinAdjustedFitness >= this.thresholdFitness && this.aquamarinGenerationOfFirstSolution == -1) {
            this.aquamarinGenerationOfFirstSolution = this.aquamarinGeneration;
        }
        Date generationEndDate = Calendar.getInstance().getTime();
        long durationMillis = generationEndDate.getTime() - this.aquamarinGenerationStartDate.getTime();
        logger.info("Generation " + this.aquamarinGeneration + ": end [" + this.aquamarinFmt.format(this.aquamarinGenerationStartDate) + " - " + this.aquamarinFmt.format(generationEndDate) + "] [" + durationMillis + "]");
    }

    public void finishSimulation() {
        this.config.getEventManager().fireGeneticEvent(new GeneticEvent("run_completed_event", this.genotype));
        Evolver.logConclusion(this.aquamarinGenerationOfFirstSolution, this.champ);
        Date runEndDate = Calendar.getInstance().getTime();
        long durationMillis = runEndDate.getTime() - this.aquamarinRunStartDate.getTime();
        logger.info("Run: end [" + this.aquamarinFmt.format(this.aquamarinRunStartDate) + " - " + this.aquamarinFmt.format(runEndDate) + "] [" + durationMillis + "]");
    }

    private static void logConclusion(int generationOfFirstSolution, Chromosome champ) {
        logger.info("generation of first solution == " + generationOfFirstSolution);
        logger.info("champ # connections == " + NeatChromosomeUtility.getConnectionList(champ.getAlleles()).size());
        logger.info("champ # hidden nodes == " + NeatChromosomeUtility.getNeuronList(champ.getAlleles(), NeuronType.HIDDEN).size());
    }

    public static Evolver instance(Properties props) throws Throwable {
        try {
            Evolver evolver = new Evolver();
            evolver.init(props);
            return evolver.run();
        }
        catch (Throwable th) {
            logger.error("", th);
            throw th;
        }
    }

    public Chromosome getChamp() {
        return this.champ;
    }

    public double getChampAdjustedFitness() {
        return this.champ == null ? 0.0 : (double)this.champ.getFitnessValue() / (double)this.config.getBulkFitnessFunction().getMaxFitnessValue();
    }

    public double getTargetFitness() {
        return this.targetFitness;
    }

    public double getThresholdFitness() {
        return this.thresholdFitness;
    }

    public ChromosomeMaterial exportChromosome(int index) {
        if (index == 0) {
            return this.genotype.getFittestChromosome().cloneMaterial();
        }
        List chromosomes = this.genotype.getChromosomes();
        if (index > chromosomes.size()) {
            return this.genotype.getFittestChromosome().cloneMaterial();
        }
        Chromosome chrom = (Chromosome)this.genotype.getChromosomes().get(index);
        return chrom.cloneMaterial();
    }

    public void importChromosome(ChromosomeMaterial chromMat, int index) {
        List chroms = this.genotype.getChromosomes();
        if (index == 0 || index > chroms.size()) {
            ((Chromosome)chroms.get(index)).importMaterial(chromMat);
        } else {
            index = (int)(Math.random() * (double)chroms.size());
            ((Chromosome)chroms.get(index)).importMaterial(chromMat);
        }
    }

    public void importChromosome(Chromosome chrom, int index) {
        this.importChromosome(chrom.cloneMaterial(), index);
    }

    public void setName(String name) {
        this.name = name;
    }
}

